#include "hprfgw_config.h"
#include "smac_app.h"
#include "smac_MC13192_hw_config.h"
#include "smac_MC13192_regs.h"
#include "smac_mcu_hw_config.h"
#include "smac_simple_phy.h"
#include "smac_simple_mac.h"
#include "smac_mcu_spi_config.h"
#include "smac_drivers.h"
#include "smac_802_15_4_shim.h"
//#include "console.h"
//#include "string_utils.h"
//#include "hardware.h"
//#include "watchdog.h"

//#include "hprfgw_rfSharedDefs.h"
//#include "hprfgw_rfSlaveIntToHost.h"
//#include "hprfgw_rfSlaveIntToRfApp.h"
#include "eep_params.h"

//TODO: Add dataMap back at some point.
//#include "nvram_dataMap.h"

//#define SEND_ACK_IN_TASK  (1)

Rf_Smac_802_PHYParams_struct Rf_Smac_802_PHYParams;
Rf_Smac_802_PIB_struct       Rf_Smac_802_PIB;
Rf_Smac_Shim_Struct          Rf_Smac_Shim;

// MNT - 5/15/2007 - We need to add this back based on whether or not this
// is HPRFGW code
//#if PROD="TPS6X"
#if 1
#else
#include "errors.h"
#include "startup.h"
#endif

volatile UINT8 gu8RTxMode; /* needed for s-mac, application can read this variable */
UINT8 led_status = 0;
volatile int gi8AppStatus = RECEIVER_ALWAYS_ON;
UINT8 link_quality;	//Holds the link quality of the last received ZigBee Packet.
UINT8 expectedString[30];
UINT32 Rfdiags_LowLevelRecvCnt = 0;
UINT32 Rfdiags_LowLevelRecvByteCnt = 0;
UINT32 prevRecvCnt = 0;
UINT32 Rfdiags_LowLevelTotalLostPackets = 0;
UINT32 corruptPacketCnt = 0;
UINT32 Rfdiags_LowLevelRetryPacketCnt = 0;
UINT32 Rfdiags_LowLevelTxPacketCnt = 0;
UINT32 Rfdiags_LowLevelTxPacketBytes = 0;
UINT32 Rfdiags_LowLevelResets = 0;
UINT32 Rfdiags_ChannelBusyResets = 0;
UINT32 Smac_numTimesChanBusy;
UINT32 Smac_ChanBusyResetFlag = 0;
UINT32 startup_time = 0;
UINT8  u8RetryNo = 0;
BOOL Smac_PhyInitialized = FALSE;
UINT32 Rfdiags_NumResetAndNacks = 0;
BOOL Smac_ResetDoneFlag = FALSE;
UINT32 Rfdiags_LowLevelPhyInitFailures = 0;
UINT32 Rfdiags_LowLevelPhyChipId = 0;

UINT32 Rfdiags_getLowLevelRecvCnt(void) { return Rfdiags_LowLevelRecvCnt; }
UINT32 Rfdiags_getLowLevelRecvByteCnt(void) { return Rfdiags_LowLevelRecvByteCnt; }
UINT32 Rfdiags_getLowLevelTotalLostPackets(void) { return Rfdiags_LowLevelTotalLostPackets; }
UINT32 Rfdiags_getLowLevelInvalidRxPacketCnt(void) { return Rfdiags_LowLevelInvalidRxPacketCnt; }
UINT32 Rfdiags_getLowLevelRetryPacketCnt(void) { return Rfdiags_LowLevelTxPacketCnt; }
UINT32 Rfdiags_getLowLevelTxPacketCnt(void) { return Rfdiags_LowLevelTxPacketCnt; }
UINT32 Rfdiags_getLowLevelTxPacketBytes(void) { return Rfdiags_LowLevelTxPacketCnt; }
UINT32 Rfdiags_getLowLevelResets(void) { return Rfdiags_LowLevelResets; }
UINT32 Rfdiags_getChannelBusyResets(void) { return Smac_numTimesChanBusy; }
UINT32 Rfdiags_getNumResetAndNacks(void) { return Rfdiags_NumResetAndNacks; }
UINT32 Rfdiags_getLowLevelPhyChipId(void) { return Rfdiags_LowLevelPhyChipId; }
UINT32 Rfdiags_getLowLevelPhyInitFailures(void) { return Rfdiags_LowLevelPhyInitFailures; }

void Smac_clearCounters(void)
{
    Rfdiags_numTimer1Ints   = 0;
    Rfdiags_numLOUnLockInts = 0;
    Rfdiags_numInvalidPhyPacketsRecvd = 0;
    Rfdiags_numCCA_TxDone = 0;
    Rfdiags_LowLevelRecvCnt = 0;
    Rfdiags_LowLevelRecvByteCnt = 0;
    Rfdiags_LowLevelTotalLostPackets = 0;
    Rfdiags_LowLevelInvalidRxPacketCnt = 0;
    Rfdiags_LowLevelRetryPacketCnt = 0;
    Rfdiags_LowLevelTxPacketCnt = 0;
    Rfdiags_LowLevelTxPacketBytes = 0;
    Rfdiags_NumCCAFailures = 0;
}


// MNT - 6/16/2008 - Added variables to Timestamp reception of packet to allow 
// upper layers to reset PHY if needed
BOOL g_bRxPktSinceReset = TRUE;
UINT32 g_u32PacketRxTime = 0;

UINT32 Smac_getLastPktRxTime(void) { return g_u32PacketRxTime; }
BOOL Smac_rxPktSinceReset(void) { return g_bRxPktSinceReset; }



// MNT - 4/27/2007 - We should really start at a random sequence number. Change this.
/// \todo
/**
 * IMPORTANT: This not being volatile causes most acks to be rejected as having the wrong
 * sequence number.
 */
volatile UINT8  smac_currSeqNo = 0;
UINT8  smac_ackSeqNo = 0; // Acknowledge with this seq number

extern UINT16 u16StatusContentAtReset;


// Ack Packet setup - Change this for the future
tTxPacket Smac_gsAckPacket;
tRxPacket Smac_gsRxPacket;
Rf_802_15_MAC_Data_Conf_struct gau8AckDataBuffer;
SMAC_TO_Rf_802_15_MAC_Frame_struct RXFrameTo802_15Shim;
Rf_802_15_MAC_TO_SMAC_Frame_struct TxFrameToSMAC;
BOOL Smac_BroadcastTxInProgress;

// Data confirmation packet to be sent back to the application
// MNT - 10/19/2007 - Changed the data confirmation message to multiple local variables
// because we don't care about maintaining the state of this information.
//mcpsDataCnf_t smac_dataConfMsg;




#if PROFILE_CODE
// Capture 64K Packets worth of timestamps. We need 4 locations for
// each transmit/receive
DebugTimeStampStruct CodeProfileLog[PROFILE_MAX_COUNT];
#endif //PROFILE_CODE


UINT16 SMAC_SM_Debug_State[SMAC_SM_DEBUG_NUMENTRIES];
UINT32 SMAC_SM_Debug_Timestamp[SMAC_SM_DEBUG_NUMENTRIES];
UINT32 SMAC_SM_Debug_State_Ctr = 0;

extern UINT32 Rfdiags_numTimer1Ints;
extern UINT32 Rfdiags_numLOUnLockInts;
extern UINT32 Rfdiags_numInvalidPhyPacketsRecvd;
extern UINT32 Rfdiags_numCCA_TxDone;


void TRXFunction(unsigned int mode);
#if defined (OS_NUCLEUS)	// This function actually not used
void TxTask(UNSIGNED argc, VOID *argv )
#elif defined (OS_WINCE)
DWORD TxTask(VOID *pContext)
#endif
void TxTask(UINT32 pContext)
{
  TRXFunction(0);
#if defined (OS_WINCE)
  return 0;
#endif
}

#if defined (OS_NUCLEUS)
void RxTask(UNSIGNED argc, VOID *argv )
#elif defined (OS_WINCE)
DWORD RxTask(VOID *pContext )
#endif
void RxTask(UINT32 pContext)
{
#if defined (OS_WINCE)
	DmConsoleLevelPrintf(DM_ERROR_LEVEL_ERROR, "\r\nRxTask: Running!");
#endif
	DmConsoleLevelPrintf(DM_ERROR_LEVEL_ERROR, "\r\nRxTask: Running!");
	TRXFunction(1);

#if defined (OS_WINCE)
  return 0;
#endif
}



TXRXTASKDATA TxRxTask;

#if defined (OS_WINCE)
// Windows CE 
 DWORD HPR_IntrThread(VOID *pContext);
#endif

/**
 *
 * \date        01-21-2008
 * \author      mtalreja
 * \brief       SMAC_IsRFChipValid
 * \detail      This function writes to the GPIO Registers and makes sure that the 
 *              GPIO lines match what's written
 * \return      BOOLEAN indicating if the RF chip is valid/present
 * \retval      0 == FALSE = Not valid
 *              1 == TRUE = Valid
 * \warning     Make sure that the GPIO pins on the processor for GPIO1-3 are initialized as inputs
 * \note        
 *
 */
BOOL SMAC_IsRFChipValid(void)
{
    UINT8 statusRead;

    // MNT - 1/21/2008 - First Initialize the chip as if it is the first initialization
    SMAC_MCUInit();
    // At this point the PHY should have been initialized, return false if that is not true
    if (Smac_PhyInitialized == FALSE)
      {
        DmConsoleLevelPrintf(DM_ERROR_LEVEL_ERROR, "PHY could not be initialized\n");
        return FALSE;
      } //if (Smac_PhyInitialized == FALSE)

    MC13192Init();

    // MNT - 1/22/2008 - By default all the pins are configured as inputs on the transceiver
    // Make it so that GPIO 1-3 are outputs. Setting bits 13-7 configure GPIO7-1 as outputs and
    // setting bits 6-0 configure GPIO7-1 as inputs. Currently, the transceiver defaults to 
    // 0x007F. We have to change it to 0x03F8
    SPIDrvWrite(GPIO_CONFIG, 0x03F8);

    // MNT - 1/21/2008 - Now write to the GPIO register and make sure that the values on the
    // pins match what they are supposed to be. By default, all GPIOs on the PHY are configured
    // as output. Leave the config bits the same as in MC13192Init
#if MC13192_IRQ_PULLUP_ENABLE
	SPIDrvWrite(GPIO_DATA, (IRQ_PULL_UP_MASK | SMAC_FCC_SIGNATURE | SMAC_GPIO_CONFIG_BITS));
#else
	SPIDrvWrite(GPIO_DATA, (SMAC_FCC_SIGNATURE | SMAC_GPIO_CONFIG_BITS));
#endif

    statusRead = MC13192ReadGPIO1_3Status();

    if (statusRead != SMAC_FCC_SIGNATURE)
      {
        DmConsoleLevelPrintf(DM_ERROR_LEVEL_ERROR, "PHY GPIO Val: 0x%x\n", statusRead);
        return FALSE;
      } // if (statusRead != SMAC_FCC_SIGNATURE)
    else
      {
        return TRUE;
      } // if (statusRead != SMAC_FCC_SIGNATURE)
}

int Smac_isResetDone(void)
{
    return Smac_ResetDoneFlag;
}

/**
 * This *MUST* be called after SMAC_IsRFChipValid is called. Ugly, but it's
 * dependent on the chip having been initialized. In practice this shouldn't
 * be a problem, the very first thing InitRFApplication does is call it.
 * \retval Returns 0 if the chip is uninitialized, or the chip version.
 */
UINT32 RF_Intfc_GetVersion(void)
{
    HPRF_DEBUG(DmConsolePrintf("Phy version: %lx\n", Rfdiags_LowLevelPhyChipId);)
    return Rfdiags_LowLevelPhyChipId;
}

/**
 *
 * \date        01-21-2008
 * \author      mtalreja
 * \brief       RF_Intfc_Init
 * \detail      Initializes the Freescale chip and other parameters
 * \return      
 * \retval      
 * \warning     
 * \note        
 *
 * \param channel             11-26
 * \param outputPower         0 for min, 0xFF for max. 1-21 are the allowed values
 * \param *deviceExtAddr      Ptr to 8 byte local EUID
 * \param CCAEnergyThreshold  Defaults based on PCC's recommendation
 * \param PowerCompOffset     Defaults based on PCC's recommendation
 */
void RF_Intfc_Init(UINT8 channel, UINT16 Power, UINT8 *deviceExtAddr, UINT8 CCAEnergyThreshold, UINT8 PowerCompOffset)
{
#if defined (OS_WINCE)
	UNSIGNED i;
	MSGQUEUEOPTIONS sMsgQueueOpt;
#elif defined (OS_NUCLEUS)
    void * pointer;
#endif
    size_t itemSize;

    DmConsolePrintf("%s - channel[%u] power[%u] cca[%u] powercomp[%u]\n",
            __FUNCTION__, channel, Power, CCAEnergyThreshold, PowerCompOffset);
  // MNT - 1/22/2008 - The following should have been called already by the IsRFChipValid function
  // Call these functions if the PHY was not initialized
  if (Smac_PhyInitialized == FALSE)
    {
      SMAC_MCUInit();
      MC13192Init();
    } // if (Smac_PhyInitialized == FALSE)
	
  // MNT - 5/4/2007 - If an invalid channel number is passed in, the lower layers will
  // automatically set the channel to the center in the ISM band. Save the params passed
  // into local databases

#if  VERBOSE_PRINTF
  DmConsolePrintf("Setting Channel %d\r\n", channel);
#endif
  Rf_Smac_802_PIB.logicalChannel = channel;
  (void)MLMESetChannelRequest(channel-11);	//Set channel zero, can be changed to users preference

#if  VERBOSE_PRINTF
  DmConsolePrintf("Setting Output Power %d\r\n", outputPower);
#endif
  Rf_Smac_802_PHYParams.outputPower = Power;
  (void)MLMEMC13192PAOutputAdjust(Power);	//Set Nominal power setting

  // MNT - 6/12/2007 - Set the CCA threshold and power compensation factor
  Rf_Smac_802_PHYParams.CCAEnergyThreshold = CCAEnergyThreshold;
  Rf_Smac_802_PHYParams.PowerCompOffset = PowerCompOffset;
  PLMESetCCAThreshPowerComp(CCAEnergyThreshold, PowerCompOffset);

  /// \review Do we need to check if the extended address is correct?
#if  VERBOSE_PRINTF
  DmConsolePrintf("Local UID (Extended Address) %02x%02x%02x%02x%02x%02x%02x%02x\r\n",
                  deviceExtAddr[0],
                  deviceExtAddr[1],
                  deviceExtAddr[2],
                  deviceExtAddr[3],
                  deviceExtAddr[4],
                  deviceExtAddr[5],
                  deviceExtAddr[6],
                  deviceExtAddr[7]
                  );
#endif
  memcpy(&Rf_Smac_802_PHYParams.deviceExtendedAddress, deviceExtAddr, sizeof(Rf_Smac_802_PHYParams.deviceExtendedAddress));

  // MNT - 9/12/2007 - Swapping the creation of the event group and the task. The task waits on events
  // and if the event group is not created when the task starts, the code will generate errors.
  // Create Event group
#if defined (OS_NUCLEUS)
  if  (NU_Create_Event_Group(&TxRxTask.events, "RFTRXEV") != NU_SUCCESS)	
  {
    DmConsolePrintError(DM_ERROR_LEVEL_FATAL, 0, 0, 0);
  }

  if  (NU_Create_Event_Group(&TxRxTask.txEvent, "RFTXEV") != NU_SUCCESS)	
  {
    DmConsolePrintError(DM_ERROR_LEVEL_FATAL, 0, 0, 0);
  }

  // Start the Rx or Tx task
  if (NU_Create_Task(&TxRxTask.task, "TTXRX", RxTask, 0,
      NU_NULL, TxRxTask.stack, sizeof(TxRxTask.stack),
      TRX_TASK_PRIORITY, 0, NU_PREEMPT, NU_START) != NU_SUCCESS)
  {
    DmConsolePrintError(DM_ERROR_LEVEL_FATAL, 0, 0, 0);
  }

  if (NU_Allocate_Memory(&System_Memory, &pointer, TRX_TASK_TORF_QUEUE_SIZE, NU_NO_SUSPEND) != NU_SUCCESS)
  {
      DmConsolePrintError(DM_ERROR_LEVEL_FATAL, 0, 0, 0);
  } // allocate memory for tx queue
    
  if (NU_Create_Pipe(&TxRxTask.toRFPipe, "RFTXQ", pointer, TRX_TASK_TORF_QUEUE_SIZE,
                  NU_VARIABLE_SIZE, sizeof(Rf_802_15_MAC_TO_SMAC_Frame_struct), NU_FIFO) != NU_SUCCESS)
  {
      DmConsolePrintError(DM_ERROR_LEVEL_FATAL, 0, 0, 0);
  } // Create pipe for outgoing rf packets

  if (NU_Allocate_Memory(&System_Memory, &pointer, TRX_TASK_FROMRF_QUEUE_SIZE, NU_NO_SUSPEND) != NU_SUCCESS)
  {
      DmConsolePrintError(DM_ERROR_LEVEL_FATAL, 0, 0, 0);
  } // allocate memory for rx queue
    
  if (NU_Create_Pipe(&TxRxTask.fromRFPipe, "RFRXQ", pointer, TRX_TASK_FROMRF_QUEUE_SIZE,
                  NU_VARIABLE_SIZE, sizeof(SMAC_TO_Rf_802_15_MAC_Frame_struct), NU_FIFO) != NU_SUCCESS)
  {
      DmConsolePrintError(DM_ERROR_LEVEL_FATAL, 0, 0, 0);
  } // Create pipe for incoming rf packets

#elif defined (OS_WINCE)
  /* Create events and store the handles in array */
  for (i = 0; i < RF_TRX_EVENTS; i++)
  {
	  // No security attributes, Auto-reset event object, Initial state is nonsignaled, Unnamed object
	  TxRxTask.hEvents[i] = CreateEvent (NULL, FALSE, FALSE, NULL);
	  if (NULL == TxRxTask.hEvents[i])
	  {
		  DmConsoleLevelPrintf(DM_ERROR_LEVEL_ERROR, "RF_Intfc_Init: Fail Create Event: %d", i);
	  }
  }
  // Just one event for the Tx
  TxRxTask.hTxEvent = CreateEvent (NULL, FALSE, FALSE, NULL);
  if (NULL == TxRxTask.hTxEvent)
  {
	DmConsoleLevelPrintf(DM_ERROR_LEVEL_ERROR, "RF_Intfc_Init: Fail Create Tx Event");
  }

  // Start the Rx or Tx task
  // The size Stack size parameter (2nd) is not used as of now because we set the 5th parameter
  // to 0. So per documentation, default stack size of 64KB is used.
  TxRxTask.task = CreateThread(NULL, 0, RxTask, pHPRDevice, 0, NULL);
  if (TxRxTask.task == NULL)
  {
    DmConsoleLevelPrintf(DM_ERROR_LEVEL_ERROR, "RF_Intfc_Init: Fail Create thread");
	DmConsolePrintError(DM_ERROR_LEVEL_FATAL, 0, 0, 0);
  }
  // Set thread priority
  CeSetThreadPriority(TxRxTask.task, TRX_TASK_PRIORITY);
/************************/
  //Set options for the message queue
  sMsgQueueOpt.dwSize = sizeof(sMsgQueueOpt);		//Size of the structure in bytes
  sMsgQueueOpt.dwFlags = 0;						    //Describes the behavior of the message queue
  sMsgQueueOpt.dwMaxMessages = 0;					//No limit on number of messages to queue at any one time, set to zero

  //if (NU_Allocate_Memory(&System_Memory, &pointer, TRX_TASK_TORF_QUEUE_SIZE, NU_NO_SUSPEND) != NU_SUCCESS)
  //{
  //    DmConsolePrintError(DM_ERROR_LEVEL_FATAL, 0, 0, 0);
  //} // allocate memory for tx queue

  //if (NU_Create_Pipe(&TxRxTask.toRFPipe, "RFTXQ", pointer, TRX_TASK_TORF_QUEUE_SIZE,
  //                NU_VARIABLE_SIZE, sizeof(Rf_802_15_MAC_TO_SMAC_Frame_struct), NU_FIFO) != NU_SUCCESS)
  //{
  //    DmConsolePrintError(DM_ERROR_LEVEL_FATAL, 0, 0, 0);
  //} // Create pipe for outgoing rf packets
  
  // Message size for RFTXQ
  sMsgQueueOpt.cbMaxMessage = sizeof(Rf_802_15_MAC_TO_SMAC_Frame_struct); //Maximum number of bytes in each message
  
  // Write handle to queue.
  sMsgQueueOpt.bReadAccess = FALSE;
  TxRxTask.hWriteHandleToRFPipe = CreateMsgQueue(TEXT("RFTXQ"),  &sMsgQueueOpt);

  // Read handle to queue
  sMsgQueueOpt.bReadAccess = TRUE;
  TxRxTask.hReadHandleToRFPipe = CreateMsgQueue(TEXT("RFTXQ"),  &sMsgQueueOpt);

  // Error check for the Message queue.
  if (TxRxTask.hWriteHandleToRFPipe == NULL || TxRxTask.hReadHandleToRFPipe == NULL)
  {
	  DmConsoleLevelPrintf(DM_ERROR_LEVEL_ERROR, "RF_Intfc_Init: Fail Create TO MsgQ");
	  DmConsolePrintError(DM_ERROR_LEVEL_FATAL, 0, 0, 0);
  }
  //if (NU_Allocate_Memory(&System_Memory, &pointer, TRX_TASK_FROMRF_QUEUE_SIZE, NU_NO_SUSPEND) != NU_SUCCESS)
  //{
  //    DmConsolePrintError(DM_ERROR_LEVEL_FATAL, 0, 0, 0);
  //} // allocate memory for rx queue
    
  //if (NU_Create_Pipe(&TxRxTask.fromRFPipe, "RFRXQ", pointer, TRX_TASK_FROMRF_QUEUE_SIZE,
  //                NU_VARIABLE_SIZE, sizeof(SMAC_TO_Rf_802_15_MAC_Frame_struct), NU_FIFO) != NU_SUCCESS)
  //{
  //    DmConsolePrintError(DM_ERROR_LEVEL_FATAL, 0, 0, 0);
  //} // Create pipe for incoming rf packets
  
  // Message size for RFRXQ
  sMsgQueueOpt.cbMaxMessage = sizeof(SMAC_TO_Rf_802_15_MAC_Frame_struct); //Maximum number of bytes in each message

  // Write handle to queue
  sMsgQueueOpt.bReadAccess = FALSE;
  TxRxTask.hWriteHandleFromRFPipe = CreateMsgQueue(TEXT("RFRXQ"),  &sMsgQueueOpt);

  // Read handle to queue
  sMsgQueueOpt.bReadAccess = TRUE;
  TxRxTask.hReadHandleFromRFPipe = CreateMsgQueue(TEXT("RFRXQ"),  &sMsgQueueOpt);
  if (NULL == TxRxTask.hWriteHandleFromRFPipe || NULL == TxRxTask.hReadHandleFromRFPipe)
  {
	  DmConsoleLevelPrintf(DM_ERROR_LEVEL_ERROR, "RF_Intfc_Init: Fail Create FROM MsgQ");
	  DmConsolePrintError(DM_ERROR_LEVEL_FATAL, 0, 0, 0);
  }
/***********************************/


#endif
  TxRxTask.events = OsCreateEventGroup();
  if(!TxRxTask.events)
  {
	  DmConsoleLevelPrintf(DM_ERROR_LEVEL_ERROR, "RF_Intfc_Init: Failed Create Event Group");
  }
  // Just one event for the Tx
  if (!OsCreateEvent(&TxRxTask.hTxEvent))
  {
	  DmConsoleLevelPrintf(DM_ERROR_LEVEL_ERROR, "RF_Intfc_Init: Fail Create Tx Event");
  }

  // Start the Rx or Tx task
  TxRxTask.task = OsCreateNamedAdvTaskPri(&RxTask, 0, 0, TRX_TASK_PRIORITY, "TTXRX");
  if (!TxRxTask.task)
  {
    DmConsoleLevelPrintf(DM_ERROR_LEVEL_ERROR, "RF_Intfc_Init: Fail Create thread");
	DmConsolePrintError(DM_ERROR_LEVEL_FATAL, 0, 0, 0);
  }
/************************/
  // Message size for RFTXQ
  itemSize = sizeof(Rf_802_15_MAC_TO_SMAC_Frame_struct);
  TxRxTask.hHandleToRFPipe = OsQueueCreate(TRX_TASK_TORF_QUEUE_SIZE/itemSize, itemSize);
  // Error check for the Message queue.
  if (!TxRxTask.hHandleToRFPipe)
  {
	  DmConsoleLevelPrintf(DM_ERROR_LEVEL_ERROR, "RF_Intfc_Init: Fail Create TO MsgQ");
	  DmConsolePrintError(DM_ERROR_LEVEL_FATAL, 0, 0, 0);
  }

  // Message size for RFRXQ
  itemSize = sizeof(SMAC_TO_Rf_802_15_MAC_Frame_struct);
  TxRxTask.hHandleFromRFPipe = OsQueueCreate(TRX_TASK_FROMRF_QUEUE_SIZE/itemSize, itemSize);
  // Error check for the Message queue.
  if (!TxRxTask.hHandleFromRFPipe)
  {
	  DmConsoleLevelPrintf(DM_ERROR_LEVEL_ERROR, "RF_Intfc_Init: Fail Create FROM MsgQ");
	  DmConsolePrintError(DM_ERROR_LEVEL_FATAL, 0, 0, 0);
  }
/***********************************/
}




void MLMEMC13192ResetIndication(void) {
	//Notifies you that the MC13192 has been reset.
	//Application must handle this here.

	gi8AppStatus = RESET_STATE;	//MC13192 reset, re-initialize.
    SMAC_LOG_DEBUG_STATE (gi8AppStatus, SMAC_SM_DEBUG_EVENT_RST_IND);
#if defined (OS_NUCLEUS)
  NU_Set_Events(&TxRxTask.events, RF_TRX_RX_ON, NU_OR);
#elif defined (OS_WINCE)
  SetEvent(TxRxTask.hEvents[RF_TRX_RX_ON]);
#endif
  OsSetEvent(TxRxTask.events, RF_TRX_RX_ON);
}




#if 0
/**
 *
 * \date        04-06-2007
 *
 * \author      mtalreja
 *
 * \brief       PhyReadCmd
 *
 * \detail      Read from the RF Phy
 *
 * \return      int
 *
 * \retval      0 - successful command
 *              -1 - if error occurred.
 *
 * \param ignore       - not used.
 * \param *cmd         - string representing the address to be read in hex
 *                                      
 */
int PhyReadCmd  (int ignore, char *cmd)
{
  UINT8 address;
  UINT16 data;

  char *p ;
	char   *endptr;

    if ( *cmd == '?')                   // print help string
    {
        ConsoleWriteData("PHYREAD address\r\n");
        ConsoleWriteData("\taddress - 6-bit address in hex\r\n");
        return 0;
    } // if ( *cmd == '?')                   // print help string

    if ( !(*cmd) )                 // print current status
    {
        ConsoleWriteData("Please enter an address in hex as a parameter\r\n");
        return 0;
    } // if ( !(*cmd) )                 // print current status

    p = strtok(cmd," -.,;:") ;
    if ( !p )
        return -1;

    address = (UINT8)strtoul(p, &endptr, 16);

    data = SPIDrvRead(address);

    DmConsolePrintf("Location 0x%08x = 0x%08x", address, data);
    return 0;  
}





/**
 *
 * \date        04-06-2007
 *
 * \author      mtalreja
 *
 * \brief       PhyWriteCmd
 *
 * \detail      Write to the RFPhy
 *
 * \return      int
 *
 * \retval      0 - successful command
 *              -1 - if error occurred.
 *
 * \param ignore       - not used.
 * \param *cmd         - string representing the address and data to be written in hex
 *                                      
 */
int PhyWriteCmd (int ignore, char *cmd)
{
  UINT8 address=0;
  UINT16 data=0;

  char *p ;
	char   *endptr;

    if ( *cmd == '?')                   // print help string
    {
        ConsoleWriteData("PHYWRITE address data\r\n");
        ConsoleWriteData("\taddress -  6-bit address in hex\r\n");
        ConsoleWriteData("\tdata    - 16-bit address in hex\r\n");
        return 0;
    } // if ( *cmd == '?')                   // print help string

    if ( !(*cmd) )                 // print current status
    {
        ConsoleWriteData("Please enter an address in hex as a parameter\r\n");
        return 0;
    } // if ( !(*cmd) )                 // print current status

    p = strtok(cmd," -.,;:") ;
    if ( !p )
        return -1;

    address = (UINT8)strtoul(p, &endptr, 16);

    p = strtok(NULL," -.,;:") ;
    if ( !p )
        return -1;
    
    data = (UINT16)strtoul(p, &endptr, 16);

    SPIDrvWrite(address, data);

    DmConsolePrintf("Wrote Location 0x%08x = 0x%08x", address, data);
    return 0;  
}






/**
 *
 * \date        04-06-2007
 *
 * \author      mtalreja
 *
 * \brief       PhyTestSetState
 *
 * \detail      Set the Phy test state
 *
 * \return      int
 *
 * \retval      0 - successful command
 *              -1 - if error occurred.
 *
 * \param ignore       - not used.
 * \param *cmd         - string representing the state in hex
 *                                      
 */
int PhyTestSetState  (int ignore, char *cmd)
{
  UINT8 state;
  UINT8 curr_link_quality;	//Holds the link quality of the last received ZigBee Packet.
  UINT32 curr_recvCnt = 0;
  UINT32 curr_Rfdiags_LowLevelTotalLostPackets = 0;
  UINT32 curr_Rfdiags_LowLevelInvalidRxPacketCnt = 0;
  UINT32 curr_corruptPacketCnt = 0;
  UINT32 curr_Rfdiags_LowLevelRetryPacketCnt = 0;
  UINT32 curr_Rfdiags_LowLevelTxPacketCnt = 0;
  UINT32 curr_time = 0;
  UINT32 curr_Rfdiags_numTimer1Ints = 0;
  UINT32 curr_Rfdiags_numLOUnLockInts = 0;
  UINT32 curr_Rfdiags_numInvalidPhyPacketsRecvd = 0;
  UINT32 curr_Rfdiags_numCCA_TxDone = 0;
  float datarate;

  char *p ;
	char   *endptr;

    if ( *cmd == '?')                   // print help string
    {
        ConsoleWriteData("PHYTESTSETSTATE address\r\n");
        ConsoleWriteData("\taddress - 6-bit address in hex\r\n");
        return 0;
    } // if ( *cmd == '?')                   // print help string

    if ( !(*cmd) )                 // print current status
    {

      // MNT - 4/10/2007 - Take a snapshot of the current numbers
      curr_time = OS_RetrieveClock();
      curr_recvCnt = Rfdiags_LowLevelRecvCnt;
      curr_Rfdiags_LowLevelTotalLostPackets = Rfdiags_LowLevelTotalLostPackets;
      curr_Rfdiags_LowLevelInvalidRxPacketCnt = Rfdiags_LowLevelInvalidRxPacketCnt;
      curr_corruptPacketCnt = corruptPacketCnt;
      curr_Rfdiags_LowLevelRetryPacketCnt = Rfdiags_LowLevelRetryPacketCnt;
      curr_Rfdiags_LowLevelTxPacketCnt = Rfdiags_LowLevelTxPacketCnt;
      state = gi8AppStatus;
      curr_Rfdiags_numTimer1Ints = Rfdiags_numTimer1Ints;
      curr_Rfdiags_numLOUnLockInts = Rfdiags_numLOUnLockInts;
      curr_Rfdiags_numInvalidPhyPacketsRecvd = Rfdiags_numInvalidPhyPacketsRecvd;
      curr_Rfdiags_numCCA_TxDone = Rfdiags_numCCA_TxDone;

      datarate = (float)curr_Rfdiags_LowLevelTxPacketCnt*(float)12600/(float)(curr_time - startup_time);
  

      DmConsolePrintf("Current State     = %d\r\n", state);
      DmConsolePrintf("TxPacket Count    = %d\r\n", curr_Rfdiags_LowLevelTxPacketCnt);
      DmConsolePrintf("Packets Received  = %d\r\n", curr_recvCnt);
      DmConsolePrintf("Packets Lost      = %d\r\n", curr_Rfdiags_LowLevelTotalLostPackets);
      DmConsolePrintf("Invalid Packets   = %d\r\n", curr_Rfdiags_LowLevelInvalidRxPacketCnt);
      DmConsolePrintf("Corrupt Packets   = %d\r\n", curr_corruptPacketCnt);
      DmConsolePrintf("Retried Packets   = %d\r\n", curr_Rfdiags_LowLevelRetryPacketCnt);
      DmConsolePrintf("Datarate          = %f bytes/second\r\n\r\n", datarate);
      DmConsolePrintf("Timer1 Ints       = %d\r\n", curr_Rfdiags_numTimer1Ints);
      DmConsolePrintf("LO Lockouts       = %d\r\n", curr_Rfdiags_numLOUnLockInts);
      DmConsolePrintf("Invalid Phy Count = %d\r\n", curr_Rfdiags_numInvalidPhyPacketsRecvd);
      DmConsolePrintf("CCAs              = %d\r\n", curr_Rfdiags_numCCA_TxDone);




        return 0;
    } // if ( !(*cmd) )                 // print current status

    p = strtok(cmd," -.,;:") ;
    if ( !p )
        return -1;

    state = (UINT8)strtoul(p, &endptr, 16);
    gi8AppStatus = state;
#if defined (OS_NUCLEUS)
	NU_Set_Events(&TxRxTask.events, RF_TRX_RX_ON, NU_OR);  //Special Event for this?
#elif defined (OS_WINCE)
	SetEvent(TxRxTask.hEvents[RF_TRX_RX_ON]);
#endif
    DmConsolePrintf("State = 0x%08x\r\n", state);
    return 0;  
}




int PhySendDataCmd  (int ignore, char *cmd)
{
  char tx_data_buffer[20];
	//tTxPacket *tx_packet;	//SMAC structure for TX packets
	//UINT8 *tx_data_buffer;	//Data buffer to hold TX data, if you want larger packets change 20 to what you need.
	nwkToMcpsMessage_t *pPacket = NULL;


  char *p ;
	char   *endptr;

    if ( *cmd == '?')                   // print help string
    {
        ConsoleWriteData("PHYSENDDATA \r\n");
//        ConsoleWriteData("\ttext - Text To Send\r\n");
        return 0;
    } // if ( *cmd == '?')                   // print help string

    //if ( !(*cmd) )                 // print current status
    //{
    //    ConsoleWriteData("Please enter text to send\r\n");
    //    return 0;
    //} // if ( !(*cmd) )                 // print current status

    //p = strtok(cmd," -.,;:") ;
    //if ( !p )
    //    return -1;

    //address = (UINT8)strtoul(p, &endptr, 16);

#if 0
    // MNT - 4/24/2007 - The memory should be cleared when the packet confirmation has been received
    /// \todo - make sure that a system is in pace for this
    if (NU_Allocate_Memory(&System_Memory, &tx_packet, sizeof(tTxPacket), NU_NO_SUSPEND) != NU_SUCCESS)
    {
        ConsoleWriteData("Cannot allocate memory for sending data\r\n");
        return -1;
    } // allocate memory for tx queue

    if (NU_Allocate_Memory(&System_Memory, &tx_data_buffer, 9, NU_NO_SUSPEND) != NU_SUCCESS)
    {
        ConsoleWriteData("Cannot allocate memory for sending data\r\n");
        return -1;
    } // allocate memory for tx queue


    tx_data_buffer[0] = 'D';
    tx_data_buffer[1] = 'a';
    tx_data_buffer[2] = 't';
    tx_data_buffer[3] = 'a';
    tx_data_buffer[4] = ' ';
    tx_data_buffer[5] = 'S';
    tx_data_buffer[6] = 'e';
    tx_data_buffer[7] = 'n';
    tx_data_buffer[8] = 't';

    tx_packet->pu8Data = &tx_data_buffer[0];	//Load the address of our txbuffer into tx structure.
    tx_packet->u8DataLength = 9;
    //(void)MCPSDataRequest(&tx_packet, TRUE, TRUE);
#endif // 


    pPacket = MSG_Alloc(sizeof(nwkToMcpsMessage_t) + 9);

 		pPacket->msgType = gMcpsDataReq_c;
    
    pPacket->msgData.dataReq.dstAddrMode = RF_802_15_MAC_FC_ADDRMODE_EXT;
    pPacket->msgData.dataReq.srcAddrMode = RF_802_15_MAC_FC_ADDRMODE_EXT;
    pPacket->msgData.dataReq.srcPanId[0] = 0xaa;
    pPacket->msgData.dataReq.srcPanId[1] = 0xaa;
    pPacket->msgData.dataReq.dstPanId[0] = 0xaa;
    pPacket->msgData.dataReq.dstPanId[1] = 0xaa;

    pPacket->msgData.dataReq.dstAddr[0] = 0xaa;
    pPacket->msgData.dataReq.dstAddr[1] = 0xbb;
    pPacket->msgData.dataReq.dstAddr[2] = 0xcc;
    pPacket->msgData.dataReq.dstAddr[3] = 0xdd;
    pPacket->msgData.dataReq.dstAddr[4] = 0xee;
    pPacket->msgData.dataReq.dstAddr[5] = 0xff;
    pPacket->msgData.dataReq.dstAddr[6] = 0x11;
    pPacket->msgData.dataReq.dstAddr[7] = 0x21;

    pPacket->msgData.dataReq.srcAddr[0] = 0xab;
    pPacket->msgData.dataReq.srcAddr[1] = 0xab;
    pPacket->msgData.dataReq.srcAddr[2] = 0xab;
    pPacket->msgData.dataReq.srcAddr[3] = 0xab;
    pPacket->msgData.dataReq.srcAddr[4] = 0xab;
    pPacket->msgData.dataReq.srcAddr[5] = 0xab;
    pPacket->msgData.dataReq.srcAddr[6] = 0xab;
    pPacket->msgData.dataReq.srcAddr[7] = 0xab;
    pPacket->msgData.dataReq.msdu[0] = 'D';
    pPacket->msgData.dataReq.msdu[1] = 'a';
    pPacket->msgData.dataReq.msdu[2] = 't';
    pPacket->msgData.dataReq.msdu[3] = 'a';
    pPacket->msgData.dataReq.msdu[4] = ' ';
    pPacket->msgData.dataReq.msdu[5] = 'S';
    pPacket->msgData.dataReq.msdu[6] = 'e';
    pPacket->msgData.dataReq.msdu[7] = 'n';
    pPacket->msgData.dataReq.msdu[8] = 't';

    pPacket->msgData.dataReq.msduLength = 9;
    pPacket->msgData.dataReq.msduHandle = 1;


#if 0
 #if defined (OS_NUCLEUS)
    if(NU_Send_To_Pipe(&TxRxTask.toRFPipe, pPacket, sizeof(nwkToMcpsMessage_t) + 9, NU_NO_SUSPEND) != NU_SUCCESS)
    {
        ConsoleWriteData("Cannot allocate send data to tx pipe\r\n");
        return -1;
    } // if(NU_Send_To_Pipe(&TxRxTask.toRFPipe, tx_packet, sizeof(tTxPacket), NU_NO_SUSPEND) != NU_SUCCESS)

    NU_Set_Events(&TxRxTask.events, RF_TRX_TX_PACKET, NU_OR);
 #elif defined (OS_WINCE)
	if (TRUE != WriteMsgQueue(TxRxTask.hWriteHandleToRFPipe, (VOID *)pPacket, (sizeof(nwkToMcpsMessage_t) + 9), OS_NO_SUSPEND, 0))
	{
		ConsoleWriteData("Cannot allocate send data to tx pipe\r\n");
		return -1;
	}
	SetEvent(TxRxTask.hEvents[RF_TRX_TX_PACKET]);
 #endif
#endif
    if (MSG_Send(NWK_MCPS, pPacket))
    {
      DmConsolePrintf("Could not send Data\r\n");
      
    } // if (MSG_Send(NWK_MCPS, pPacket))
    else
    {
      DmConsolePrintf("Sent Data\r\n");
    }

    return 0;  
}





#endif  //#if0 debug commands


/**
 *
 * \date        
 *
 * \author      mtalreja
 *
 * \brief       MCPSDataIndication
 *
 * \detail      
 *
 * \return      
 *
 * \retval      
 *
 * \param *gsRxPacket 
 */
void MCPSDataIndication(tRxPacket *gsRxPacket)
{
    Rf_802_15_MAC_Data_Frame_struct *rxFrame;
    Rf_802_15_MAC_Data_Conf_struct *ackFrame;
    Rf_802_15_MAC_Data_FrameCtlField_struct frmCtl;
    UINT8 broadcastPANId[] =
    { 0xFF, 0xFF };
    UINT8 broadcastUId[] =
    { 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF };
    BOOL isPanIdBroadcast = FALSE;
    BOOL isUIdBroadcast = FALSE;
    UINT32 currTime = 0;
    mcpsToNwkMessage_t smac_dataConfMsg;
#if SMAC_SM_DEBUG
    UINT8 debug_datalen;
    //int delayctr;
#endif
    UINT32 queuedFromRxBytes;

    /*
     * Place your code here to handle a mac layer data indication.
     * RX packet is in the global structure
     * gsRxPacket.dataLength and gsRxPacket.data
     */

    // MNT - 6/13/2007 - At this point check to make sure that RF is enabled,
    // If not, just return without processing - it is as if we did not receive
    // anything
    if (Rf_Smac_802_PIB.rfDisabled == TRUE) {
        return;
    } //if (Rf_Smac_802_PIB.rfDisabled == TRUE)

    currTime = PLMEGetTimeRequest();

    if (gsRxPacket->u8Status == SMAC_SUCCESS) {
        // MNT - 6/16/2008 - Timestamp reception of packet to allow upper layers to reset
        // PHY if needed
        //g_u32PacketRxTime = TMD_System_Clock;
        g_u32PacketRxTime = OS_RetrieveClock();
        g_bRxPktSinceReset = TRUE;

        /* Packet received */
        if (gi8AppStatus == WAITING_FOR_ACK) {

            // If we are waiting for an ACK - we cannot handle getting any other packets
            // Discard the packet and go to the timeout state. If we want to receive
            // packets while waiting for an ACK, the architecture will have to change
            // MNT - 5/23/2007 - Updated state machine to allow for accepting of packets
            // even when we are waiting for an ack

            // Check if this is an ACK
            ackFrame = (Rf_802_15_MAC_Data_Conf_struct*) gsRxPacket->pu8Data;
            // Frame control endianness must be swapped
            SMAC_SWAP_ENDIANNESS(ackFrame->frameCtl);
            memcpy(&frmCtl, &ackFrame->frameCtl, sizeof(ackFrame->frameCtl));

            if (gsRxPacket->u8DataLength == sizeof(Rf_802_15_MAC_Data_Conf_struct)) {
                SMAC_LOG_DEBUG_STATE_RAW(0x1111, HwGetMsec());
            }
            else {
                SMAC_LOG_DEBUG_STATE_RAW(0x0000, HwGetMsec());
            }

            if ((gsRxPacket->u8DataLength == sizeof(Rf_802_15_MAC_Data_Conf_struct))
                    && (frmCtl.frameType == RF_802_15_MAC_FC_FRTYPE_ACK)) {
                HPRF_PROFILE(TxRecvAck);
                if (ackFrame->seqNo != smac_currSeqNo) {
                    // MNT - 5/21/2007 - This is an error condition for us - shut down the TIMER
                    // Since we are waiting for the ACK the timer should be running
                    SPIDrvWrite(T1_HI_ADDR, 0x8000); /* Disables TC1 and clears the
                     * IRQ. */
                    SPIDrvWrite(T1_LO_ADDR, 0x0000);

                    /* TIMEOUT */
                    SMAC_SET_APP_STATE(TIMEOUT_STATE);
                    SMAC_LOG_DEBUG_STATE(gi8AppStatus, SMAC_SM_DEBUG_EVENT_MCPSD_IND_TIMEOUT);
#if defined (OS_NUCLEUS)
                    NU_Set_Events(&TxRxTask.events, RF_TRX_TX_TIMEOUT, NU_OR);
#elif defined (OS_WINCE)
                    SetEvent(TxRxTask.hEvents[RF_TRX_TX_TIMEOUT]);
#endif
                    OsSetEvent(TxRxTask.events, RF_TRX_TX_TIMEOUT);
                    HPRF_PROFILE(TxTimeoutAck);
                    Rfdiags_LowLevelInvalidRxPacketCnt++;
                } // else if (ackFrame->seqNo != smac_currSeqNo)
                else {
                    // MNT - 5/21/2007 - Valid ACK received, shut down the timer
                    // Since we are waiting for the ACK the timer should be running
                    SPIDrvWrite(T1_HI_ADDR, 0x8000); /* Disables TC1 and clears the
                     * IRQ. */
                    SPIDrvWrite(T1_LO_ADDR, 0x0000);

                    // MNT - 10/18/2007 - We will send the app ack right here instead of the task
                    SMAC_LOG_DEBUG_STATE(gi8AppStatus, SMAC_SM_DEBUG_EVENT_MCPSD_IND_TIMEOUT_APP_ACK);

                    /* Valid ack received. Send The app Ack*/
                    smac_dataConfMsg.msgType = gMcpsDataCnf_c;
                    smac_dataConfMsg.msgData.dataCnf.msduHandle = TxFrameToSMAC.msduHandle;
                    smac_dataConfMsg.msgData.dataCnf.status = gSuccess_c;
                    // 20120227 PM Update the link quality for a successful ack we got so that we keep the link quality value
                    // updated. This is helpful to keep the link quality updated when there is no activity otherthan the heartbeat.
                    // This is only used in slave device (processed in RFRecMsg_MCPMessageProcessing() function)
                    smac_dataConfMsg.msgData.dataCnf.lqi = gsRxPacket->lqi;
#if defined (OS_NUCLEUS)
                    MSG_Queue(&Rf_Smac_Shim.McpsNwkInputQueue, &smac_dataConfMsg, sizeof(smac_dataConfMsg));
#elif defined (OS_WINCE)
                    MSG_Queue(Rf_Smac_Shim.hWriteMcpsNwkInputQueue, &smac_dataConfMsg, sizeof(smac_dataConfMsg));
#endif
                    HPRF_QUEUE_DEBUG(DmConsolePrintf("=== %s:%i ---> queueing packet size %lu to mcpsNwkInputQueue\n", \
                            __FUNCTION__, __LINE__, sizeof(smac_dataConfMsg));)
                    OsQueueBytes(Rf_Smac_Shim.hMcpsNwkInputQueue, &smac_dataConfMsg, sizeof(smac_dataConfMsg));

                    SMAC_SET_APP_STATE(RECEIVER_ALWAYS_ON);
                    u8RetryNo = 0;
                    // MNT - 5/4/2007 - Increment the sequence number because the packet
                    // was acknowledged
                    smac_currSeqNo++;
                    // MNT - 4/24/2007 - Done transmitting. Set the flags to receive data
                    SMAC_LOG_DEBUG_STATE(gi8AppStatus, SMAC_SM_DEBUG_EVENT_APP_ACK_DONE);
#if defined (OS_NUCLEUS)
                    NU_Set_Events(&TxRxTask.events, RF_TRX_RX_PACKET, NU_OR);
#elif defined (OS_WINCE)
                    SetEvent(TxRxTask.hEvents[RF_TRX_RX_PACKET]);
#endif
                    OsSetEvent(TxRxTask.events, RF_TRX_RX_PACKET);
                } // end if (ackFrame->seqNo != smac_currSeqNo)

            } // if ACK FRAME received
            else {

                // MNT - 5/23/2007 - If the packet received is really intended for us,
                // indicate a timeout condition, in addition to putting the packet into
                // the receive queue
                // MNT - 6/26/2007 - Allow broadcast frames in
                rxFrame = (Rf_802_15_MAC_Data_Frame_struct *) gsRxPacket->pu8Data;

                // PRASAD - need conversion?

                // MNT - 6/26/2007 - Find out if the packet is broadcast
                if (AreBytesDiff(rxFrame->header.dstPanId, (UINT8 *) broadcastPANId,
                        sizeof(rxFrame->header.dstPanId))) {
                    isPanIdBroadcast = FALSE;
                } // panid is not broadcast
                else {
                    isPanIdBroadcast = TRUE;
                } // panid is broadcast

                if (AreBytesDiff(rxFrame->header.dstAddr, broadcastUId, sizeof(rxFrame->header.dstAddr))) {
                    isUIdBroadcast = FALSE;
                } // uid is not broadcast
                else {
                    isUIdBroadcast = TRUE;
                } // uid is broadcast

                // PRASAD - need conversion?

                if ((gsRxPacket->u8DataLength < (sizeof(Rf_802_15_MAC_Data_FrameHdr_struct) + 1))
                        || ((AreBytesDiff(rxFrame->header.dstPanId, (UINT8 *) &Rf_Smac_802_PIB.panId,
                                sizeof(rxFrame->header.dstPanId))) && (isPanIdBroadcast == FALSE))
                        || ((AreBytesDiff(rxFrame->header.dstAddr, Rf_Smac_802_PHYParams.deviceExtendedAddress,
                                sizeof(rxFrame->header.dstAddr))) && (isUIdBroadcast == FALSE))) {

                    // MNT - 5/21/2007 - This is an error condition for us - shut down the TIMER
                    // Since we are waiting for the ACK the timer should be running
                    SPIDrvWrite(T1_HI_ADDR, 0x8000); /* Disables TC1 and clears the
                     * IRQ. */
                    SPIDrvWrite(T1_LO_ADDR, 0x0000);

                    /* TIMEOUT */
                    SMAC_SET_APP_STATE(TIMEOUT_STATE);
                    SMAC_LOG_DEBUG_STATE(gi8AppStatus, SMAC_SM_DEBUG_EVENT_MCPSD_IND_INVPKT_TIMEOUT);
#if defined (OS_NUCLEUS)
                    NU_Set_Events(&TxRxTask.events, RF_TRX_TX_TIMEOUT, NU_OR);
#elif defined (OS_WINCE)
                    SetEvent(TxRxTask.hEvents[RF_TRX_TX_TIMEOUT]);
#endif
                    OsSetEvent(TxRxTask.events, RF_TRX_TX_TIMEOUT);
                    HPRF_PROFILE(TxTimeoutAck);
                    Rfdiags_LowLevelInvalidRxPacketCnt++;
                } // if invalid frame received during ACK period
                else {
                    Rfdiags_LowLevelRecvCnt++;
                    // MNT - 5/23/2007 - We received a valid frame. Shut down the timer, indicate
                    // to the state machine that it has to send an ACK out as well as send a timeout
                    // condition to the upper layers
                    SPIDrvWrite(T1_HI_ADDR, 0x8000); /* Disables TC1 and clears the
                     * IRQ. */
                    SPIDrvWrite(T1_LO_ADDR, 0x0000);

                    /* TIMEOUT with sending of TXACK */
                    // MNT - 6/20/2007 - The ISR will now take care of going to receive mode
                    // and moving the state to retransmit if necessary
                    SMAC_LOG_DEBUG_STATE(gi8AppStatus, SMAC_SM_DEBUG_EVENT_MCPSD_IND_VALIDPKT_TIMEOUT);

                    HPRF_PROFILE(TxTimeoutAck);
                    // Set the ACK sequence number to the value received in the frame. This way the
                    // state machine can send the correct ACK
                    smac_ackSeqNo = rxFrame->header.sequenceNo;

#ifndef SEND_ACK_IN_TASK
                    // MNT - 5/25/2007 - The ACK is now send in the ISR itself
                    // Set the sequence number and transmit

#if 0
#pragma info "!!!!  Make sure that this delay is around 600us  !!!!"

//          RFIntHostApp.pF_HwDelayUsec(500);
                    for (delayctr=0; delayctr<6000; delayctr++)
                    asm(" nop");
#endif

                    SMAC_LOG_DEBUG_STATE(gi8AppStatus, SMAC_SM_DEBUG_EVENT_MCPSD_IND_DELAYDONE);

                    gau8AckDataBuffer.seqNo = smac_ackSeqNo;
                    // MNT - 6/26/2007 - Send ACK only if not broadcast
                    if ((isUIdBroadcast == FALSE) && (isPanIdBroadcast == FALSE)) {
                        (void) MCPSDataRequest(&Smac_gsAckPacket, FALSE, FALSE); /* transmit data without CCA*/
                    } // not a broadcast packet
                      // MNT - 5/29/2007 - Retry number should not be zeroed out here - we could
                      // be retransmitting.
#endif  // #ifndef SEND_ACK_IN_TASK
                      // MNT - 5/23/2007 - Insert the packet into the Rx queue
                      // MNT - 6/12/2007 - At this point we know that the data that we received was part of the RXFrameTo802_15Shim
                      // structure. Instead of just passing in the data. pass in the structure.
                      // In addition, fill the lqi into the structure to be sent
                    RXFrameTo802_15Shim.Lqi = gsRxPacket->lqi;
#if defined (OS_NUCLEUS)
                    if (NU_Send_To_Pipe(&TxRxTask.fromRFPipe,
                                    &RXFrameTo802_15Shim,
                                    gsRxPacket->u8DataLength + SMAC_TO_Rf_802_15_MAC_Frame_HDRSIZE,
                                    NU_NO_SUSPEND) != NU_SUCCESS)
                    {
                        /// \todo Figure out how to handle this error condition
                        //            ConsoleWriteData("Cannot allocate send data to Rx pipe\r\n");
                        //            return -1;
                    } // if(NU_Send_To_Pipe(&TxRxTask.fromRFPipe, &RXFrameTo802_15Shim, sizeof(tRxPacket), NU_NO_SUSPEND) != NU_SUCCESS)

                    NU_Set_Events(&TxRxTask.events, RF_TRX_RX_PACKET, NU_OR);
#elif defined (OS_WINCE)
                    if (TRUE != WriteMsgQueue(TxRxTask.hWriteHandleFromRFPipe, (VOID*)&RXFrameTo802_15Shim, (gsRxPacket->u8DataLength + SMAC_TO_Rf_802_15_MAC_Frame_HDRSIZE), OS_NO_SUSPEND, 0))
                    {
                        /// \todo Figure out how to handle this error condition
                        //  ConsoleWriteData("Cannot allocate send data to Rx pipe\r\n");
                        //  return -1;
                        DmConsoleLevelPrintf(DM_ERROR_LEVEL_ERROR, "Cannot send data to FROM-Rx pipe", GetLastError());

                    }
                    SetEvent(TxRxTask.hEvents[RF_TRX_RX_PACKET]);
#endif
                    HPRF_QUEUE_DEBUG(DmConsolePrintf("=== %s:%i ---> queueing %u bytes to FromRFPipe\n", \
                            __FUNCTION__, __LINE__, \
                            (gsRxPacket->u8DataLength + SMAC_TO_Rf_802_15_MAC_Frame_HDRSIZE));)
                    queuedFromRxBytes = OsQueueBytes(TxRxTask.hHandleFromRFPipe, (void*) &RXFrameTo802_15Shim,
                            (gsRxPacket->u8DataLength + SMAC_TO_Rf_802_15_MAC_Frame_HDRSIZE));
                    if (queuedFromRxBytes <= 0) {
                        DmConsoleLevelPrintf(DM_ERROR_LEVEL_ERROR, "Cannot send data to FROM-Rx pipe err=%lu\n", queuedFromRxBytes);
                    }
                    OsSetEvent(TxRxTask.events, RF_TRX_RX_PACKET);
                    //DmConsolePrintf(" --- received %lu bytes --- \n", rxBytes);
                    Rfdiags_LowLevelRecvByteCnt += gsRxPacket->u8DataLength;

                    // MNT - 6/20/2007 - Move Task code to ISR -- begin

                    // MNT - 5/23/2007 - Step 1 - Send ACK over the air
                    prevRecvCnt = Rfdiags_LowLevelRecvCnt;

                    // MNT - 5/23/2007 - Step 2 - Evaluate if we are going to retransmit or
                    // timeout. If we have to retransmit, just set the state correctly
                    // MNT - 7/19/2007 - The following section of code might be causing result
                    // code timeouts. Just go back to receive mode and allow the task state
                    // machine to take care of retries
#if 0 // Do not resend packet here start
                    if (u8RetryNo < SMAC_RETRY_COUNT)
                    {
                        SMAC_SET_APP_STATE(RE_TRANSMIT_DATA); /* Retransmit. */
                        Rfdiags_LowLevelRetryPacketCnt++;
                        u8RetryNo++;
                        // MNT - 4/24/2007 - Done transmitting. Set the flags to receive data
                        SMAC_LOG_DEBUG_STATE (gi8AppStatus, SMAC_SM_DEBUG_EVENT_TXACK_WTO_RETR);
#if defined (OS_NUCLEUS)
                        NU_Set_Events(&TxRxTask.events, RF_TRX_TX_RETX, NU_OR);
#elif defined (OS_WINCE)
                        SetEvent(TxRxTask.hEvents[RF_TRX_TX_RETX]);
#endif
                        OsSetEvent(TxRxTask.events, RF_TRX_TX_RETX);
                    }
                    else
                    {
                        /* Give up on packet. Send the NACK*/
                        smac_dataConfMsg.msgType = gMcpsDataCnf_c;
                        smac_dataConfMsg.msgData.dataCnf.msduHandle = TxFrameToSMAC.msduHandle;
                        smac_dataConfMsg.msgData.dataCnf.status = gNoAck_c;
#if defined (OS_NUCLEUS)
                        MSG_Queue(&Rf_Smac_Shim.McpsNwkInputQueue, &smac_dataConfMsg, sizeof(smac_dataConfMsg));
#elif defined (OS_WINCE)
                        MSG_Queue(Rf_Smac_Shim.hWriteMcpsNwkInputQueue, &smac_dataConfMsg, sizeof(smac_dataConfMsg));
#endif
                        OsQueue(Rf_Smac_Shim.hWriteMcpsNwkInputQueue, &smac_dataConfMsg, sizeof(smac_dataConfMsg));

                        u8RetryNo = 0;
                        // MNT - 5/4/2007 - Increment the sequence number because the packet
                        // was not acknowledged and we gave up
                        smac_currSeqNo++;
                        // MNT - 4/24/2007 - Done transmitting. Set the flags to receive data
                        SMAC_LOG_DEBUG_STATE (gi8AppStatus, SMAC_SM_DEBUG_EVENT_TIMEOUTSTATE_GIVEUP);

                        (void)MLMERXEnableRequest(&Smac_gsRxPacket, 0);
                        //MCU_LOW_POWER_WHILE();
                        SMAC_SET_APP_STATE(WAITING_FOR_RX);

                        SMAC_LOG_DEBUG_STATE (gi8AppStatus, SMAC_SM_DEBUG_EVENT_MCPSD_IND_VALIDPKTRXMODEDONE);

#if defined (OS_NUCLEUS)
                        NU_Set_Events(TxRxTask.events, RF_TRX_RX_PACKET, NU_OR);
#elif defined (OS_WINCE)
                        SetEvent(TxRxTask.hEvents[RF_TRX_RX_PACKET]);
#endif
                        OsSetEvent(TxRxTask.events, RF_TRX_RX_PACKET);
                        Rfdiags_LowLevelTotalLostPackets++;
                    } // retry count
#endif // #if 0 Do not resend packet here end
                    // MNT - 7/19/2007 Read the current time. If it is greater than the SMAC timeout
                    // period, send a NACK up. Otherwise, just wait for 50 PHY Timer ticks and make it
                    // generate a timeout interrupt. 50 timer ticks at 250 KHz = 200us
                    if (currTime >= (SMAC_TIMEOUT_PERIOD - SMAC_IMMEDIATE_TIMEOUT_PERIOD)) {
                        SMAC_SM_TurnOnRxWTO(SMAC_IMMEDIATE_TIMEOUT_PERIOD);
                    } //if (currTime >= SMAC_TIMEOUT_PERIOD)
                    else {
                        // Turn on the receiver for the rest of the duration we need to wait for
                        // In this else, currTime is always less than or equal to
                        // SMAC_TIMEOUT_PERIOD-SMAC_IMMEDIATE_TIMEOUT_PERIOD. So, the turn on time
                        // cannot be a very large number.
                        SMAC_SM_TurnOnRxWTO(SMAC_TIMEOUT_PERIOD - currTime - 10);
                    } //if (currTime >= SMAC_TIMEOUT_PERIOD-SMAC_IMMEDIATE_TIMEOUT_PERIOD)

                    // MNT - 6/20/2007 - Move Task code to ISR -- end

                } // end if invalid frame received during ACK period

            } // end if ACK FRAME received

            // MNT - 5/21/2007 - If the packet is not an ack packet and we are waiting
            // we should

        } // else if (gi8AppStatus == WAITING_FOR_ACK)
        else /* Not an WAITING FOR ACK */
        {
            HPRF_DEBUG(DmConsolePrintf("Not waiting for ack\n");)
            // MNT - 5/21/2007 - We will not shut down the timer because we are in receive
            // mode and we are receiving a packet

            Rfdiags_LowLevelRecvCnt++;
            Rfdiags_LowLevelRecvByteCnt += gsRxPacket->u8DataLength;

#if PROFILE_CODE
            //CodeProfileLog[((Rfdiags_LowLevelTxPacketCnt<<2)|(u8RetryNo&0x3))%PROFILE_MAX_COUNT].packetIndex = Rfdiags_LowLevelTxPacketCnt;
            //CodeProfileLog[HPRF_PROFILE_INDEX()].packetIndex = Rfdiags_LowLevelTxPacketCnt;
            HPRF_PROFILE_PKT_INDEX();
            //CodeProfileLog[((Rfdiags_LowLevelTxPacketCnt<<2)|(u8RetryNo&0x3))%PROFILE_MAX_COUNT].RxRecvdTimeStamp = CURRENT_TIME_STAMP;
            HPRF_PROFILE(RxRecvd);
#endif // PROFILE_CODE
            // If the frame received is smaller than the smallest packet that can be received
            // just discard it. Smallest packet is a 1 byte payload with the MAC Frame Header
            if (gsRxPacket->u8DataLength < (sizeof(Rf_802_15_MAC_Data_FrameHdr_struct) + 1)) {
                // Just return - We don't know what this packet is and we should not really care
                // Change this if we are going to support MAC packets or a frame header that
                // does not have all extended addresses
                /// \todo
                // MNT - 5/11/2007 - Go back to receive mode before returning

                RTXENAssert();
                if (gi8AppStatus == WAITING_FOR_ACK) {
                    SMAC_SET_APP_STATE(RECEIVER_ON_WTO);
                    // MNT - 7/19/2007 Read the current time. If it is greater than the SMAC timeout
                    // period, send a NACK up. Otherwise, just wait for 50 PHY Timer ticks and make it
                    // generate a timeout interrupt. 50 timer ticks at 250 KHz = 200us
                    if (currTime >= (SMAC_TIMEOUT_PERIOD - SMAC_IMMEDIATE_TIMEOUT_PERIOD)) {
                        SMAC_SM_TurnOnRxWTO(SMAC_IMMEDIATE_TIMEOUT_PERIOD);
                    } //if (currTime >= SMAC_TIMEOUT_PERIOD)
                    else {
                        // Turn on the receiver for the rest of the duration we need to wait for
                        // In this else, currTime is always less than or equal to
                        // SMAC_TIMEOUT_PERIOD-SMAC_IMMEDIATE_TIMEOUT_PERIOD. So, the turn on time
                        // cannot be a very large number.
                        SMAC_SM_TurnOnRxWTO(SMAC_TIMEOUT_PERIOD - currTime - 10);
                    } //if (currTime >= SMAC_TIMEOUT_PERIOD-SMAC_IMMEDIATE_TIMEOUT_PERIOD)
                } // we are currently waiting for an ack
                else {
                    SMAC_SET_APP_STATE(RECEIVER_ALWAYS_ON);
                } // endif we are waiting for an ack

                SMAC_LOG_DEBUG_STATE(gi8AppStatus, SMAC_SM_DEBUG_EVENT_MCPSD_IND_BADPKT);
#if defined (OS_NUCLEUS)
                NU_Set_Events(&TxRxTask.events, RF_TRX_RX_PACKET, NU_OR);
#elif defined (OS_WINCE)
                SetEvent(TxRxTask.hEvents[RF_TRX_RX_PACKET]);
#endif
                OsSetEvent(TxRxTask.events, RF_TRX_RX_PACKET);
                Rfdiags_LowLevelInvalidRxPacketCnt++;
                return;
            } // if (gsRxPacket->u8DataLength < (sizeof(Rf_802_15_MAC_Data_FrameHdr_struct) + 1))

            rxFrame = (Rf_802_15_MAC_Data_Frame_struct *) gsRxPacket->pu8Data;

            // PRASAD - need conversion?
            // MNT - 6/26/2007 - Find out if the packet is broadcast
            if (AreBytesDiff(rxFrame->header.dstPanId, (UINT8 *) broadcastPANId, sizeof(rxFrame->header.dstPanId))) {
                isPanIdBroadcast = FALSE;
            } // panid is not broadcast
            else {
                isPanIdBroadcast = TRUE;
            } // panid is broadcast

            // PRASAD - need conversion?
            if (AreBytesDiff(rxFrame->header.dstAddr, broadcastUId, sizeof(rxFrame->header.dstAddr))) {
                isUIdBroadcast = FALSE;
            } // uid is not broadcast
            else {
                isUIdBroadcast = TRUE;
            } // uid is broadcast

//TODO: FIXME: remove.
//            DmConsolePrintf("dstPan = %02hx%02hx "
//                    "dstAddr = %02hx %02hx %02hx %02hx %02hx %02hx %02hx %02hx "
//                    "isPanIdBroadcast = %u isUidBroadcast = %u\n",
//                    rxFrame->header.dstPanId[0], rxFrame->header.dstPanId[1],
//                    rxFrame->header.dstAddr[0], rxFrame->header.dstAddr[1],
//                    rxFrame->header.dstAddr[2], rxFrame->header.dstAddr[3],
//                    rxFrame->header.dstAddr[4], rxFrame->header.dstAddr[5],
//                    rxFrame->header.dstAddr[6], rxFrame->header.dstAddr[7],
//                    isPanIdBroadcast, isUIdBroadcast);

            // PRASAD - need conversion?
            // Compare the PANID and Extended address stored with the destination address. Discard if not
            // the same.
            // MNT - 6/26/2007 - Allow broadcast packets
            if ((AreBytesDiff(rxFrame->header.dstPanId, (UINT8 *) &Rf_Smac_802_PIB.panId,
                    sizeof(rxFrame->header.dstPanId))) && (isPanIdBroadcast == FALSE)) {
                // Return, not meant for us
                // MNT - 5/11/2007 - Go back to receive mode before returning

//                DmConsolePrintf("%s --- not our pan pkt=%02hx%02hx ours=%hx\n", __FUNCTION__,
//                        rxFrame->header.dstPanId[0], rxFrame->header.dstPanId[1], Rf_Smac_802_PIB.panId);
                RTXENAssert();
                if (gi8AppStatus == WAITING_FOR_ACK) {
                    SMAC_SET_APP_STATE(RECEIVER_ON_WTO);
                    // MNT - 7/19/2007 Read the current time. If it is greater than the SMAC timeout
                    // period, send a NACK up. Otherwise, just wait for 50 PHY Timer ticks and make it
                    // generate a timeout interrupt. 50 timer ticks at 250 KHz = 200us
                    if (currTime >= (SMAC_TIMEOUT_PERIOD - SMAC_IMMEDIATE_TIMEOUT_PERIOD)) {
                        SMAC_SM_TurnOnRxWTO(SMAC_IMMEDIATE_TIMEOUT_PERIOD);
                    } //if (currTime >= SMAC_TIMEOUT_PERIOD)
                    else {
                        // Turn on the receiver for the rest of the duration we need to wait for
                        // In this else, currTime is always less than or equal to
                        // SMAC_TIMEOUT_PERIOD-SMAC_IMMEDIATE_TIMEOUT_PERIOD. So, the turn on time
                        // cannot be a very large number.
                        SMAC_SM_TurnOnRxWTO(SMAC_TIMEOUT_PERIOD - currTime - 10);
                    } //if (currTime >= SMAC_TIMEOUT_PERIOD-SMAC_IMMEDIATE_TIMEOUT_PERIOD)
                } // we are currently waiting for an ack
                else {
                    SMAC_SET_APP_STATE(RECEIVER_ALWAYS_ON);
                } // endif we are waiting for an ack
                SMAC_LOG_DEBUG_STATE(gi8AppStatus, SMAC_SM_DEBUG_EVENT_MCPSD_IND_BADPANID);
#if defined (OS_NUCLEUS)
                NU_Set_Events(&TxRxTask.events, RF_TRX_RX_PACKET, NU_OR);
#elif defined (OS_WINCE)
                SetEvent(TxRxTask.hEvents[RF_TRX_RX_PACKET]);
#endif
                OsSetEvent(TxRxTask.events, RF_TRX_RX_PACKET);
                Rfdiags_LowLevelInvalidRxPacketCnt++;
                return;
            } // if (AreBytesDiff(rxFrame->header.dstPanId, Rf_Smac_802_PIB.panId, sizeof(rxFrame->header.dstPanId)))

            // PRASAD - need conversion?
            if ((AreBytesDiff(rxFrame->header.dstAddr, Rf_Smac_802_PHYParams.deviceExtendedAddress,
                    sizeof(rxFrame->header.dstAddr))) && (isUIdBroadcast == FALSE)) {
                // Return, not meant for us
                // MNT - 5/11/2007 - Go back to receive mode before returning

//                DmConsolePrintf("%s --- not our address\n", __FUNCTION__);
                RTXENAssert();
                if (gi8AppStatus == WAITING_FOR_ACK) {
                    SMAC_SET_APP_STATE(RECEIVER_ON_WTO);
                    // MNT - 7/19/2007 Read the current time. If it is greater than the SMAC timeout
                    // period, send a NACK up. Otherwise, just wait for 50 PHY Timer ticks and make it
                    // generate a timeout interrupt. 50 timer ticks at 250 KHz = 200us
                    if (currTime >= (SMAC_TIMEOUT_PERIOD - SMAC_IMMEDIATE_TIMEOUT_PERIOD)) {
                        SMAC_SM_TurnOnRxWTO(SMAC_IMMEDIATE_TIMEOUT_PERIOD);
                    } //if (currTime >= SMAC_TIMEOUT_PERIOD)
                    else {
                        // Turn on the receiver for the rest of the duration we need to wait for
                        // In this else, currTime is always less than or equal to
                        // SMAC_TIMEOUT_PERIOD-SMAC_IMMEDIATE_TIMEOUT_PERIOD. So, the turn on time
                        // cannot be a very large number.
                        SMAC_SM_TurnOnRxWTO(SMAC_TIMEOUT_PERIOD - currTime - 10);
                    } //if (currTime >= SMAC_TIMEOUT_PERIOD-SMAC_IMMEDIATE_TIMEOUT_PERIOD)
                } // we are currently waiting for an ack
                else {
                    SMAC_SET_APP_STATE(RECEIVER_ALWAYS_ON);
                } // endif we are waiting for an ack
                SMAC_LOG_DEBUG_STATE(gi8AppStatus, SMAC_SM_DEBUG_EVENT_MCPSD_IND_BADUID);
#if defined (OS_NUCLEUS)
                NU_Set_Events(&TxRxTask.events, RF_TRX_RX_PACKET, NU_OR);
#elif defined (OS_WINCE)
                SetEvent(TxRxTask.hEvents[RF_TRX_RX_PACKET]);
#endif
                OsSetEvent(TxRxTask.events, RF_TRX_RX_PACKET);
                Rfdiags_LowLevelInvalidRxPacketCnt++;
                return;
            } // if (AreBytesDiff(rxFrame->header.dstAddr, Rf_Smac_802_PHYParams.deviceExtendedAddress, sizeof(rxFrame->header.dstAddr)))

            // Set the ACK sequence number to the value received in the frame. This way the
            // state machine can send the correct ACK
            smac_ackSeqNo = rxFrame->header.sequenceNo;
            SMAC_SET_APP_STATE(TRANSMIT_ACK);

            SMAC_LOG_DEBUG_STATE(gi8AppStatus, SMAC_SM_DEBUG_EVENT_MCPSD_IND_RXPKTBEFOREACK);

#ifndef SEND_ACK_IN_TASK
            // MNT - 5/25/2007 - The ACK is now send in the ISR itself
            // Set the sequence number and transmit
            HwDelayUsec(50);

#if 0
#pragma info "!!!!  Make sure that this delay is around 600us  !!!!"

            //     RFIntHostApp.pF_HwDelayUsec(500);
            for (delayctr=0; delayctr<6000; delayctr++)
            asm(" nop");
#endif

            SMAC_LOG_DEBUG_STATE(gi8AppStatus, SMAC_SM_DEBUG_EVENT_MCPSD_IND_DELAYDONE);

            gau8AckDataBuffer.seqNo = smac_ackSeqNo;

            if ((isUIdBroadcast == FALSE) && (isPanIdBroadcast == FALSE)) {
                (void) MCPSDataRequest(&Smac_gsAckPacket, FALSE, FALSE); /* transmit data without CCA*/
            } // not a broadcast packet

            u8RetryNo = 0;
#endif // #ifndef SEND_ACK_IN_TASK
            // MNT - 4/24/2007 - Insert the packet into the Rx queue
            // MNT - 6/12/2007 - At this point we know that the data that we received was part of the RXFrameTo802_15Shim
            // structure. Instead of just passing in the data. pass in the structure
            // In addition, fill the lqi into the structure to be sent
            RXFrameTo802_15Shim.Lqi = gsRxPacket->lqi;
#if defined (OS_NUCLEUS)
            if (NU_Send_To_Pipe(&TxRxTask.fromRFPipe,
                            &RXFrameTo802_15Shim,
                            gsRxPacket->u8DataLength + SMAC_TO_Rf_802_15_MAC_Frame_HDRSIZE,
                            NU_NO_SUSPEND) != NU_SUCCESS)
#elif defined (OS_WINCE)
            if (TRUE != WriteMsgQueue(TxRxTask.hWriteHandleFromRFPipe, (VOID*)&RXFrameTo802_15Shim, (gsRxPacket->u8DataLength + SMAC_TO_Rf_802_15_MAC_Frame_HDRSIZE), OS_NO_SUSPEND, 0))
#endif
            HPRF_QUEUE_DEBUG(DmConsolePrintf("=== %s:%i ---> queueing %u bytes to FromRFPipe\n", \
                    __FUNCTION__, __LINE__, \
                    (gsRxPacket->u8DataLength + SMAC_TO_Rf_802_15_MAC_Frame_HDRSIZE));)
            if (OsQueueBytes(TxRxTask.hHandleFromRFPipe, (void*) &RXFrameTo802_15Shim,
                    (gsRxPacket->u8DataLength + SMAC_TO_Rf_802_15_MAC_Frame_HDRSIZE)) < 0) {
                /// \todo Figure out how to handle this error condition
                //            ConsoleWriteData("Cannot allocate send data to Rx pipe\r\n");
                //            return -1;
#if defined (OS_WINCE)
                DmConsoleLevelPrintf(DM_ERROR_LEVEL_ERROR, "Error send data to FROM RF pipe", GetLastError());
#endif
            } // if(NU_Send_To_Pipe(&TxRxTask.fromRFPipe, &RXFrameTo802_15Shim, sizeof(tRxPacket), NU_NO_SUSPEND) != NU_SUCCESS)

            SMAC_LOG_DEBUG_STATE(gi8AppStatus, SMAC_SM_DEBUG_EVENT_MCPSD_IND_RXPKT);

            // MNT - 6/20/2007 - Moved the receive mode to the ISR -- begin
            // MNT - 4/10/2007 - Reset the retry number to 0
            u8RetryNo = 0;
            prevRecvCnt = Rfdiags_LowLevelRecvCnt;

            (void) MLMERXEnableRequest(&Smac_gsRxPacket, 0);
            //MCU_LOW_POWER_WHILE();
            SMAC_SET_APP_STATE(WAITING_FOR_RX);

            SMAC_LOG_DEBUG_STATE(gi8AppStatus, SMAC_SM_DEBUG_EVENT_MCPSD_IND_RXMODEDONE);
            // MNT - 6/20/2007 - Moved the receive mode to the ISR -- end

#if defined (OS_NUCLEUS)
            NU_Set_Events(&TxRxTask.events, RF_TRX_RX_PACKET, NU_OR);
#elif defined (OS_WINCE)
            SetEvent(TxRxTask.hEvents[RF_TRX_RX_PACKET]);
#endif
            OsSetEvent(TxRxTask.events, RF_TRX_RX_PACKET);
        } /* end if Not an ACK */

    } // if (gsRxPacket->u8Status == SMAC_SUCCESS)

    if (gsRxPacket->u8Status == TIMEOUT) {
        /* Received TIMEOUT */
        SMAC_SET_APP_STATE(TIMEOUT_STATE);
#if SMAC_SM_DEBUG
        SMAC_LOG_DEBUG_STATE(gi8AppStatus, SMAC_SM_DEBUG_EVENT_MCPSD_IND_PHYTIMEOUT);

        debug_datalen = (UINT8) (SPIDrvRead(RX_PKT_LEN) & 0x7F);
        if (debug_datalen == sizeof(Rf_802_15_MAC_Data_Conf_struct)) {
            SMAC_LOG_DEBUG_STATE(gi8AppStatus, SMAC_SM_DEBUG_EVENT_TIMEOUT_BUT_PKTRCVD);
        }
#endif
#if defined (OS_NUCLEUS)
        NU_Set_Events(&TxRxTask.events, RF_TRX_TX_TIMEOUT, NU_OR);
#elif defined (OS_WINCE)
        SetEvent(TxRxTask.hEvents[RF_TRX_TX_TIMEOUT]);
#endif
        OsSetEvent(TxRxTask.events, RF_TRX_TX_TIMEOUT);
        HPRF_PROFILE(TxTimeoutAck);
    } // if (gsRxPacket->u8Status == TIMEOUT)

}





void TRXFunction(unsigned int mode)
{
#if defined (OS_NUCLEUS)
    STATUS status;
#endif
    INT32 status;
    tTxPacket txPacket = {};

    Rf_802_15_MAC_Data_Frame_struct *rxFrame;
    Rf_802_15_MAC_Data_FrameCtlField_struct frmCtl;

    UINT32 gsTxPacketSizeFromPipe = 0;
    UINT32 retrieved_events = 0;
    UINT32 waitfor_events = 0;
#if defined (OS_WINCE)
    UINT32 wait_event_count = 0;
    HANDLE hWaitfor_Events[RF_TRX_EVENTS] = {0, 0, 0, 0, 0};
    UINT32 i = 0;
    DWORD dwWaitObjectReturnVal;
    DWORD dwFlags;			// just for reading sake, not used.
#endif
    UINT8 txResult;
    BOOL isTraceEnabled = FALSE;
    mcpsToNwkMessage_t smac_dataConfMsg;

    // Initialize the ACK frame to be sent
    Smac_gsAckPacket.pu8Data = (UINT8*) &gau8AckDataBuffer;
    Smac_gsAckPacket.u8DataLength = sizeof(gau8AckDataBuffer);

    SetFrameCtlDefaults(&frmCtl);
    frmCtl.frameType = RF_802_15_MAC_FC_FRTYPE_ACK;
    gau8AckDataBuffer.frameCtl = frmCtl;

    // Initialize the Receive frame
    // MNT - 6/11/2007 - RXFrameTo802_15Shim is the structure that should be passed upto the shim
    // layer because it has the LQI. However, to avoid changing the SMAC layer to understand details
    // about the upper layers, we just pass in the data. Currently, we can only receive one packet at
    // a time. As soon as the packet is received, the HISR pushes the data into the shim pipe. So, this
    // RXFrameTo802_15Shim data structure can be shared between the trx function and the MCPSDataIndication
    // function. In other words, there is no protection from multiple tasks/ISRs corrupting data.
    // This architecture will have to be changed if this assumption is not true.
    rxFrame = &(RXFrameTo802_15Shim.RfData);
    Smac_gsRxPacket.u8MaxDataLength = 127;
    Smac_gsRxPacket.pu8Data = (UINT8 *) rxFrame;

    //TODO: revisit
    //RFIntHostApp.pF_StartupWait();

#if  VERBOSE_PRINTF
    DmConsolePrintf("Starting Transceiver\r\n");
#endif
    SMAC_SET_APP_STATE(RECEIVER_ALWAYS_ON);
#if defined (OS_NUCLEUS)
    NU_Set_Events(&TxRxTask.events, RF_TRX_RX_PACKET, NU_OR);
#elif defined (OS_WINCE)
    SetEvent(TxRxTask.hEvents[RF_TRX_RX_PACKET]);
#endif
    OsSetEvent(TxRxTask.events, RF_TRX_RX_PACKET);

    startup_time = OS_RetrieveClock();

    for (;;) {

        // MNT - 7/7/07 - If the Reset flag was set, send a reset to the PHY.
        // The SMAC_SM_ResetPhy_And_Nack function will send a NACK only if we
        // are currently transmitting a packet sent by the upper layers.
        // The channel busy reset flag is set if 75% of the tries to access the
        // channel lead to a channel access failure. It either implies that the
        // channel is extremely busy and we cannot get access for 75% of the time
        // even with random backoffs or that there is something wrong with the phy.
        // In either case, resetting the PHY should not cause that much of an impact.
        // The gateway currently completely locks up and this is a mechanism for us
        // to detect the lockup.
        if (Smac_ChanBusyResetFlag == 1) {

            SMAC_LOG_DEBUG_STATE(gi8AppStatus, SMAC_SM_DEBUG_EVENT_CHANBUSY_RESET);
            Smac_ChanBusyResetFlag = 0;
            Smac_numTimesChanBusy = 0;
            Rfdiags_ChannelBusyResets++;
            SMAC_SM_ResetPhy_And_Nack();
        } //      if (Smac_ChanBusyResetFlag == 1)

        // Only listen to TX event if we are waiting for RX
        if (gi8AppStatus != WAITING_FOR_RX) {
#if defined (OS_NUCLEUS)
            waitfor_events = (unsigned long)(RF_TRX_RX_PACKET | RF_TRX_TX_RETX | RF_TRX_TX_TIMEOUT | RF_TRX_RX_ON);
#elif defined (OS_WINCE)
            // We have to fill up the array with the events to wait on.
            wait_event_count = 4;
            hWaitfor_Events[0] = TxRxTask.hEvents[RF_TRX_RX_PACKET];
            hWaitfor_Events[1] = TxRxTask.hEvents[RF_TRX_TX_RETX];
            hWaitfor_Events[2] = TxRxTask.hEvents[RF_TRX_TX_TIMEOUT];
            hWaitfor_Events[3] = TxRxTask.hEvents[RF_TRX_RX_ON];
#endif
            waitfor_events = (unsigned long) (RF_TRX_RX_PACKET | RF_TRX_TX_RETX | RF_TRX_TX_TIMEOUT | RF_TRX_RX_ON);
        } // else if (gi8AppStatus != WAITING_FOR_RX)
        else {
#if defined (OS_NUCLEUS)
            waitfor_events = (unsigned long)(RF_TRX_RX_PACKET | RF_TRX_TX_PACKET | RF_TRX_TX_RETX | RF_TRX_TX_TIMEOUT | RF_TRX_RX_ON);
#elif defined (OS_WINCE)
            wait_event_count = 5;
            hWaitfor_Events[0] = TxRxTask.hEvents[RF_TRX_RX_PACKET];
            hWaitfor_Events[1] = TxRxTask.hEvents[RF_TRX_TX_PACKET];
            hWaitfor_Events[2] = TxRxTask.hEvents[RF_TRX_TX_RETX];
            hWaitfor_Events[3] = TxRxTask.hEvents[RF_TRX_TX_TIMEOUT];
            hWaitfor_Events[4] = TxRxTask.hEvents[RF_TRX_RX_ON];
#endif
            waitfor_events = (unsigned long) (RF_TRX_RX_PACKET | RF_TRX_TX_RETX | RF_TRX_TX_TIMEOUT | RF_TRX_RX_ON |
                    RF_TRX_TX_PACKET);
        } // end if (gi8AppStatus != WAITING_FOR_RX)

        // Wait till an event is received
        /// \todo Instead of listening to all events all the time only listen to
        /// the correct events - If we transmitted a packet, only listen to
        /// non TX events. This will prevent us from trying to corrupt an MSDU handle
#if defined (OS_NUCLEUS)
        if (NU_Retrieve_Events(&TxRxTask.events,
                        (unsigned long)waitfor_events,
                        NU_OR_CONSUME,
                        &retrieved_events,
                        NU_SUSPEND) != NU_SUCCESS)
        {
            DmConsoleLevelPrintf(DM_ERROR_LEVEL_ERROR, "RFTRXTASK: Failed to retrieve events\n");
            continue;
        } // if retrieve events
#elif defined (OS_WINCE)
        // Wait for Multiple Objects
        dwWaitObjectReturnVal = WaitForMultipleObjects(wait_event_count, hWaitfor_Events, FALSE, OS_SUSPEND);
        if (dwWaitObjectReturnVal == WAIT_FAILED)
        {
            DmConsoleLevelPrintf(DM_ERROR_LEVEL_ERROR, "RFTRXTASK: Failed to retrieve events\n");
            continue;
        }
#endif
        retrieved_events = OsWaitForEventAndClear(TxRxTask.events, waitfor_events);
        if (!retrieved_events) {
            DmConsoleLevelPrintf(DM_ERROR_LEVEL_ERROR, "RFTRXTASK: Failed to retrieve events\n");
            continue;
        } // if retrieve events

        // MNT - 4/23/2007 - Handle the case when you get TX and other events at the
        // same time. Give priority to other events.
        // One way to do this is to not consume all events earlier. If both events
        // are set, just consume the RX first and then consume the TX event
        // Also, handle multiple TX packets by not consuming till the last packet is received
        /// \todo
        // MNT - 5/10/2007 - For some reason, the unrequested events are being set as well
        // even though they are not consumed. Mask them.
#if defined (OS_NUCLEUS)
        retrieved_events &= waitfor_events;
        if (retrieved_events & RF_TRX_TX_PACKET)
#elif defined (OS_WINCE)
        // Get the index (above array) of the handle which satisifed wait
        dwWaitObjectReturnVal = dwWaitObjectReturnVal - WAIT_OBJECT_0;
        // Per Jana, check for out of array index, just in case...
        if (dwWaitObjectReturnVal > (wait_event_count-1))
        {
            DmConsoleLevelPrintf(DM_ERROR_LEVEL_ERROR, "RFTRXTASK: Event index out of boundary.\n");
            continue;
        }

        // Now check, if the required Event satisifed the wait.
        if (hWaitfor_Events[dwWaitObjectReturnVal] == TxRxTask.hEvents[RF_TRX_TX_PACKET])
#endif
        retrieved_events &= waitfor_events;
        if (retrieved_events & RF_TRX_TX_PACKET) {
            HPRF_DEBUG(DmConsolePrintf("============= transmitting packet =============\n");)
            // MNT - 10/19/2007 - If any events other than tx event were set, they would get lost
#if defined (OS_NUCLEUS)
            NU_Set_Events(&TxRxTask.events, (retrieved_events & ~RF_TRX_TX_PACKET), NU_OR);

            status = NU_Receive_From_Pipe(&TxRxTask.toRFPipe,
                    &TxFrameToSMAC,
                    sizeof(TxFrameToSMAC),
                    &gsTxPacketSizeFromPipe,
                    NU_NO_SUSPEND);

            if (status != NU_SUCCESS)
            {
                /// \todo - Handle the error correctly over here
                RFIntHostApp.pF_IsRFRxDebugTraceEnabled(&isTraceEnabled);
                if (isTraceEnabled)
                {
                    DmConsolePrintf("RFTRXTASK: No data received from pipe: 0x%x\r\n", status);
                }
                continue;
            } // if receive from pipe
#elif defined (OS_WINCE)
            // This is not needed in WINCE as there is no chance of other events getting lost.
            //NU_Set_Events(&TxRxTask.events, (retrieved_events &  ~RF_TRX_TX_PACKET), NU_OR);
            if (TRUE != ReadMsgQueue(TxRxTask.hReadHandleToRFPipe, (void*) &TxFrameToSMAC, sizeof (Rf_802_15_MAC_TO_SMAC_Frame_struct), &gsTxPacketSizeFromPipe, OS_NO_SUSPEND, &dwFlags))
            {
                DmConsoleLevelPrintf(DM_ERROR_LEVEL_ERROR, "RFTRXTASK: No data received from pipe.");
                /// \todo - Handle the error correctly over here
                RFIntHostApp.pF_IsRFRxDebugTraceEnabled(&isTraceEnabled);
                if (isTraceEnabled)
                {
                    DmConsolePrintf("RFTRXTASK: No data received from pipe.");
                }
                continue;
            }
#endif
            //OsSetEvent(TxRxTask.events, (retrieved_events & ~RF_TRX_TX_PACKET));
            status = OsDequeueBytesWait(TxRxTask.hHandleToRFPipe, &TxFrameToSMAC, sizeof (Rf_802_15_MAC_TO_SMAC_Frame_struct), OS_NO_WAIT);
            HPRF_QUEUE_DEBUG(DmConsolePrintf("=== %s:%i <--- dequeued %li bytes from ToRFPipe\n", \
                    __FUNCTION__, __LINE__, status);)
            if (status < 0) {
                // TODO: Put this somewhere?
                // - Handle the error correctly over here
                //RFIntHostApp.pF_IsRFRxDebugTraceEnabled(&isTraceEnabled);
                isTraceEnabled = true;
                if (isTraceEnabled) {
                    DmConsolePrintf("RFTRXTASK: No data received from pipe: %li\r\n", status);
                }
                continue;

            }
            HPRF_DEBUG(print_hex_dump(KERN_INFO, "shim queue ", DUMP_PREFIX_ADDRESS, \
                  16, 1, &TxFrameToSMAC, status, true);)
            // MNT - 5/31/2007 - Check to make sure if there are any more messages
            // set the flag again if it is true
#if defined (OS_NUCLEUS)
            if (MSG_Pending(&TxRxTask.toRFPipe) == TRUE)
            {
                NU_Set_Events(&TxRxTask.events, RF_TRX_TX_PACKET, NU_OR);
            }
#elif defined (OS_WINCE)
            if (MSG_Pending(TxRxTask.hReadHandleToRFPipe) == TRUE)
            {
                SetEvent(TxRxTask.hEvents[RF_TRX_TX_PACKET]);
            }
#endif

            if(OsGetQueueCount(TxRxTask.hHandleToRFPipe)) {
                OsSetEvent(TxRxTask.events, RF_TRX_TX_PACKET);
            }
            gsTxPacketSizeFromPipe = status;

            // Set the correct sequence number - Incremented only when we receive
            // a correct ACK - do not increment here
            TxFrameToSMAC.RfData.header.sequenceNo = smac_currSeqNo;
            txPacket.pu8Data = (UINT8*) &TxFrameToSMAC.RfData;
            // subtract one byte for the msdu handle
            txPacket.u8DataLength = (UINT8) (gsTxPacketSizeFromPipe - sizeof(TxFrameToSMAC.msduHandle));

            // MNT - 6/26/2007 - Check to see if this is a broadcast message. If it is, transmit it
            // and just send an ACK back to the app

            Smac_BroadcastTxInProgress = FALSE;

            if ((TxFrameToSMAC.RfData.header.dstPanId[0] == 0xFF)
                    && (TxFrameToSMAC.RfData.header.dstPanId[1] == 0xFF)) {

                SMAC_LOG_DEBUG_STATE(gi8AppStatus, SMAC_SM_DEBUG_EVENT_TX_BROADCASTPKT);
                Smac_BroadcastTxInProgress = TRUE;
                Rfdiags_LowLevelTxPacketCnt++;
                Rfdiags_LowLevelTxPacketBytes += txPacket.u8DataLength;

                // Transmit the message
                MLMERXDisableRequest(); /* Turn off the RX forever mode. */
                txResult = MCPSDataRequest(&txPacket, TRUE, TRUE);

                smac_dataConfMsg.msgType = gMcpsDataCnf_c;
                smac_dataConfMsg.msgData.dataCnf.msduHandle = TxFrameToSMAC.msduHandle;
                if (txResult == SMAC_CCA_FAILED) {
                    smac_dataConfMsg.msgData.dataCnf.status = gChannelAccessFailure_c;
                } // if (txResult == SMAC_CCA_FAILED)
                else {
                    smac_dataConfMsg.msgData.dataCnf.status = gSuccess_c;
                } // end if (txResult == SMAC_CCA_FAILED)
#if defined (OS_NUCLEUS)
                MSG_Queue(&Rf_Smac_Shim.McpsNwkInputQueue, &smac_dataConfMsg, sizeof(smac_dataConfMsg));
#elif defined (OS_WINCE)
                MSG_Queue(Rf_Smac_Shim.hWriteMcpsNwkInputQueue, &smac_dataConfMsg, sizeof(smac_dataConfMsg));
#endif
                HPRF_QUEUE_DEBUG(DmConsolePrintf("=== %s:%i ---> queueing %u bytes to mcpsNwkInputQueue\n", \
                        __FUNCTION__, __LINE__, \
                        sizeof(smac_dataConfMsg));)
                MSG_Queue(Rf_Smac_Shim.hMcpsNwkInputQueue, &smac_dataConfMsg, sizeof(smac_dataConfMsg));
                u8RetryNo = 0;
                // MNT - 5/4/2007 - Increment the sequence number because the packet
                // will never be acknowledged
                smac_currSeqNo++;

                // MNT - 7/20/07 - Make sure that somebody did not move us to the
                // idle state while transmitting before changing states. Idle state
                // means something bad happened and we need to reset
                if (gi8AppStatus != IDLE_STATE) {
                    SMAC_SET_APP_STATE(RECEIVER_ALWAYS_ON);
#if defined (OS_NUCLEUS)
                    // MNT - 4/24/2007 - Done transmitting. Set the flags to receive data
                    NU_Set_Events(&TxRxTask.events, RF_TRX_RX_PACKET, NU_OR);
#elif defined (OS_WINCE)
                    SetEvent(TxRxTask.hEvents[RF_TRX_RX_PACKET]);
#endif
                    OsSetEvent(TxRxTask.events, RF_TRX_RX_PACKET);
                } // if (gi8AppStatus != IDLE_STATE)

                // check the next event coming in
                continue;
            } // if broadcast frame

            // Set the correct state - to transmit data
            SMAC_SET_APP_STATE(TRANSMIT_DATA);

        } // if retrieved tx event

        // MNT - 6/13/2007 - At this point check to make sure that RF is enabled,
        // If not, we just need to go to Idle state
        // MNT - 7/30/2007 - Make sure that reset passes through
        if ((Rf_Smac_802_PIB.rfDisabled == TRUE) && (gi8AppStatus != RESET_STATE)) {
            gi8AppStatus = IDLE_STATE;
        } //if (Rf_Smac_802_PIB.rfDisabled == TRUE)

        SMAC_LOG_DEBUG_STATE(gi8AppStatus, SMAC_SM_DEBUG_EVENT_INSM);

        switch (gi8AppStatus)
        {

        case SHUTDOWN_STATE:
            break;

        case IDLE_STATE:
            // Stay here till told to move
            break;

        case RESET_STATE:
            //MC13192 Reset, reinitialize and return to default state (TX_STATE).
            Rfdiags_LowLevelResets++;
            if (u16StatusContentAtReset) {
                DmConsoleLevelPrintf(DM_ERROR_LEVEL_ERROR, "Reset from Phy. Stat at reset = 0x%4x\r\n",
                        u16StatusContentAtReset);
            }

            MC13192Init();
            PLMESetChannelRequest(Rf_Smac_802_PIB.logicalChannel - 11);
            PLMEMC13192PAOutputAdjust(Rf_Smac_802_PHYParams.outputPower);	//Set power setting
            PLMESetCCAThreshPowerComp(Rf_Smac_802_PHYParams.CCAEnergyThreshold, Rf_Smac_802_PHYParams.PowerCompOffset);
            gi8AppStatus = RECEIVER_ALWAYS_ON; // No Need to go to IDLE
            Smac_ResetDoneFlag = TRUE;
            SMAC_LOG_DEBUG_STATE(gi8AppStatus, SMAC_SM_DEBUG_EVENT_RXON_AFTER_RST);

#if defined (OS_NUCLEUS)
            NU_Set_Events(&TxRxTask.events, RF_TRX_RX_ON, NU_OR);
#elif defined (OS_WINCE)
            SetEvent(TxRxTask.hEvents[RF_TRX_RX_ON]);
#endif
            OsSetEvent(TxRxTask.events, RF_TRX_RX_ON);
            // Don't break, just go to RECEIVER_ALWAYS_ON State

        case RECEIVER_ALWAYS_ON:
            u8RetryNo = 0;
            (void) MLMERXEnableRequest(&Smac_gsRxPacket, 0);
            //MCU_LOW_POWER_WHILE();
            SMAC_SET_APP_STATE(WAITING_FOR_RX)
            ;
            // Don't set any events. Any state change from here will be
            // due to an event - either a receive or a transmit
            break;

        case RECEIVER_ON_WTO:
            // MNT - 4/24/2007 - Don't set any events - should happen from ISR
            // MNT - 5/14/2007 - For now just wait for the same timeout period
            // for an ack we might have to adjust this
            // MNT - 6/14/2007 - We now go rx with timeout mode in the ISR
            break;

            // This state is just like the RECEIVER_ALWAYS_ON state - you
            // cannot get out unless you receive an event
        case WAITING_FOR_ACK:
            /* Do nothing.  Go to sleep waiting for TO or RX_ACK */
            break;

            // This state is just like the RECEIVER_ALWAYS_ON state - you
            // cannot get out unless you receive an event
        case WAITING_FOR_RX:
            /* Do nothing.  Go to sleep waiting for RX */
            break;

        case TRANSMIT_DATA:
            SMAC_SET_APP_STATE(RECEIVER_ALWAYS_ON);
            Rfdiags_LowLevelTxPacketCnt++;
            // MNT - 7/27/07 - Initialize the channel busy counter to allow reset
            Smac_numTimesChanBusy = 0;

#if PROFILE_CODE
            //CodeProfileLog[HPRF_PROFILE_INDEX()].packetIndex = Rfdiags_LowLevelTxPacketCnt;
            HPRF_PROFILE_PKT_INDEX();
            HPRF_PROFILE(TxState);
#endif // PROFILE_CODE
            if (MLMERXDisableRequest() != SMAC_SUCCESS) { /* Turn off the RX forever mode. */
                SMAC_SET_APP_STATE(RE_TRANSMIT_DATA);
                SMAC_LOG_DEBUG_STATE(gi8AppStatus, SMAC_SM_DEBUG_EVENT_TXDATA_RXDISFAILED);
#if defined (OS_NUCLEUS)
                NU_Set_Events(&TxRxTask.events, RF_TRX_TX_RETX, NU_OR);
#elif defined (OS_WINCE)
                SetEvent(TxRxTask.hEvents[RF_TRX_TX_RETX]);
#endif
                OsSetEvent(TxRxTask.events, RF_TRX_TX_RETX);
                // MNT - 4/24/2007 - Log this as an error
                DmConsoleLevelPrintf(DM_ERROR_LEVEL_ERROR,
                        "RFTRXTASK: Failed to switch to transmit mode in TRANSMIT_DATA\n");
                break;
            }

            /* transmit data */
#if SMAC_SM_DEBUG
#endif
            Rfdiags_LowLevelTxPacketBytes += txPacket.u8DataLength;
            txResult = MCPSDataRequest(&txPacket, TRUE, TRUE);
            if (txResult == SMAC_SUCCESS) {
                SMAC_LOG_DEBUG_STATE(gi8AppStatus, SMAC_SM_DEBUG_EVENT_TXDATA_DONETX);
                // MNT - 4/24/2007 - Don't set any events - should happen from ISR
                // MNT - 6/14/2007 - We now go rx with timeout mode in the ISR

                // MNT - 4/24/2007 - Done transmitting. Set the flags to receive data
                // MNT - 6/5/2007 - Since we have done transmitting, the only thing
                // we can receive is either an ACK or a timeout interrupt. These
                // are taken care of in the MCPSDataIndication function and they will
                // move the state appropriately. Until then, stay in this state and
                // don't go to to the receive state
            } // if ((MCPSDataRequest(&gsTxPacket, TRUE, TRUE) == SMAC_SUCCESS))  /* transmit data */
            else {
                // MNT - 6/5/2007 - At this point, either a CCA error occured or we did not get a
                // TX interrupt - both are bad conditions. Since this is the transmit state, always
                // retransmit
                SMAC_SET_APP_STATE(RE_TRANSMIT_DATA); /* Retransmit. */
                Rfdiags_LowLevelRetryPacketCnt++;
                u8RetryNo++;

                SMAC_LOG_DEBUG_STATE(gi8AppStatus, SMAC_SM_DEBUG_EVENT_TXDATA_FAILED_RETX);
#if defined (OS_NUCLEUS)
                NU_Set_Events(&TxRxTask.events, RF_TRX_TX_RETX, NU_OR);
#elif defined (OS_WINCE)
                SetEvent(TxRxTask.hEvents[RF_TRX_TX_RETX]);
#endif
                OsSetEvent(TxRxTask.events, RF_TRX_TX_RETX);
            } // tx result is not a success

            HPRF_PROFILE(TxDone);
            break;

            //RETransmit is same as transmit except we don't increment the packet count
        case RE_TRANSMIT_DATA:

            HPRF_PROFILE(TxState);
            SMAC_SET_APP_STATE(RECEIVER_ALWAYS_ON)
            ;
            if (MLMERXDisableRequest() != SMAC_SUCCESS) { /* Turn off the RX forever mode. */
                SMAC_SET_APP_STATE(RE_TRANSMIT_DATA);
                SMAC_LOG_DEBUG_STATE(gi8AppStatus, SMAC_SM_DEBUG_EVENT_RETXDATA_RXDISFAILED);
#if defined (OS_NUCLEUS)
                NU_Set_Events(&TxRxTask.events, RF_TRX_TX_RETX, NU_OR);
#elif defined (OS_WINCE)
                SetEvent(TxRxTask.hEvents[RF_TRX_TX_RETX]);
#endif
                OsSetEvent(TxRxTask.events, RF_TRX_TX_RETX);
                // MNT - 4/24/2007 - Log this as an error
                /// \todo
                DmConsoleLevelPrintf(DM_ERROR_LEVEL_ERROR,
                        "RFTRXTASK: Failed to switch to transmit mode in RE_TRANSMIT_DATA\n");
                break;
            }

            /* transmit data */
#if SMAC_SM_DEBUG
#endif
            // MNT - 8/22/07 - Increment packet count when we retry as well.
            Rfdiags_LowLevelTxPacketCnt++;
            Rfdiags_LowLevelTxPacketBytes += txPacket.u8DataLength;
            txResult = MCPSDataRequest(&txPacket, TRUE, TRUE);
            if (txResult == SMAC_SUCCESS) {
                SMAC_LOG_DEBUG_STATE(gi8AppStatus, SMAC_SM_DEBUG_EVENT_RETXDATA_DONETX);
                // MNT - 4/24/2007 - Don't set any events - should happen from ISR
                // MNT - 6/14/2007 - We now go rx with timeout mode in the ISR

                // MNT - 4/24/2007 - Done transmitting. Set the flags to receive data
                // MNT - 6/5/2007 - Since we have done transmitting, the only thing
                // we can receive is either an ACK or a timeout interrupt. These
                // are taken care of in the MCPSDataIndication function and they will
                // move the state appropriately. Until then, stay in this state and
                // don't go to to the receive state
            } // if ((MCPSDataRequest(&gsTxPacket, TRUE, TRUE) == SMAC_SUCCESS))  /* transmit data */
            else {
                // MNT - 6/5/2007 - At this point, either a CCA error occured or we did not get a
                // TX interrupt - both are bad conditions. Either retransmit or go to a timeout state
                if (u8RetryNo < SMAC_RETRY_COUNT) {
                    // This will always be true for the first transmission
                    SMAC_SET_APP_STATE(RE_TRANSMIT_DATA); /* Retransmit. */
                    Rfdiags_LowLevelRetryPacketCnt++;
                    u8RetryNo++;

                    SMAC_LOG_DEBUG_STATE(gi8AppStatus, SMAC_SM_DEBUG_EVENT_RETXDATA_FAILED_RETX);
#if defined (OS_NUCLEUS)
                    NU_Set_Events(&TxRxTask.events, RF_TRX_TX_RETX, NU_OR);
#elif defined (OS_WINCE)
                    SetEvent(TxRxTask.hEvents[RF_TRX_TX_RETX]);
#endif
                    OsSetEvent(TxRxTask.events, RF_TRX_TX_RETX);
                } // if (u8RetryNo < SMAC_RETRY_COUNT)
                else // if (u8RetryNo < SMAC_RETRY_COUNT)
                {
                    /* Give up on packet. Send the NACK*/
                    smac_dataConfMsg.msgType = gMcpsDataCnf_c;
                    smac_dataConfMsg.msgData.dataCnf.msduHandle = TxFrameToSMAC.msduHandle;
                    if (txResult == SMAC_CCA_FAILED) {
                        smac_dataConfMsg.msgData.dataCnf.status = gChannelAccessFailure_c;
                    } // if (txResult == SMAC_CCA_FAILED)
                    else {
                        smac_dataConfMsg.msgData.dataCnf.status = gNoAck_c;
                    } // end if (txResult == SMAC_CCA_FAILED)
#if defined (OS_NUCLEUS)
                    MSG_Queue(&Rf_Smac_Shim.McpsNwkInputQueue, &smac_dataConfMsg, sizeof(smac_dataConfMsg));
#elif defined (OS_WINCE)
                    MSG_Queue(Rf_Smac_Shim.hWriteMcpsNwkInputQueue, &smac_dataConfMsg, sizeof(smac_dataConfMsg));
#endif
                    HPRF_QUEUE_DEBUG(DmConsolePrintf("=== %s:%i ---> queueing %u bytes to mcpsNwkInputQueue\n", \
                            __FUNCTION__, __LINE__, \
                            sizeof(smac_dataConfMsg));)
                    OsQueueBytes(Rf_Smac_Shim.hMcpsNwkInputQueue, &smac_dataConfMsg, sizeof(smac_dataConfMsg));
                    SMAC_SET_APP_STATE(RECEIVER_ALWAYS_ON);
                    u8RetryNo = 0;
                    // MNT - 5/4/2007 - Increment the sequence number because the packet
                    // was not acknowledged and we gave up
                    smac_currSeqNo++;
                    // MNT - 4/24/2007 - Done transmitting. Set the flags to receive data
                    SMAC_LOG_DEBUG_STATE(gi8AppStatus, SMAC_SM_DEBUG_EVENT_RETXDATA_FAILED_TIMEOUT);
#if defined (OS_NUCLEUS)
                    NU_Set_Events(&TxRxTask.events, RF_TRX_RX_PACKET, NU_OR);
#elif defined (OS_WINCE)
                    SetEvent(TxRxTask.hEvents[RF_TRX_RX_PACKET]);
#endif
                    OsSetEvent(TxRxTask.events, RF_TRX_RX_PACKET);
                    Rfdiags_LowLevelTotalLostPackets++;

                }                    // end if (u8RetryNo < SMAC_RETRY_COUNT)

            } // end if tx is a success

            HPRF_PROFILE(TxDone);
            break;

        case TRANSMIT_ACK:
            // MNT - 4/18/2007 - Currently the ACK is transmitted in the task - move it
            // to the ISR if this causes a lot of problems
            // MNT - 5/25/2007 - It started causing a lot of problems :)
            // This is now being moved into the ISR
            // MNT - 6/20/2007 - Go to receive mode in the ISR as well - the ISR to
            // task latency sometimes is in the order of 100 ms. This causes the
            // transceiver to miss data - do nothing in this state
            break;

        case TXACK_WTO:
            // MNT - 4/18/2007 - Currently the ACK is transmitted in the task - move it
            // to the ISR if this causes a lot of problems
            // MNT - 5/23/2007 - This state will send the ack over the air and send
            // a timeout to the upper layers
            // MNT - 5/25/2007 - Sending the ACK in the task is causing problems
            // Do this in the ISR
            // MNT - 6/20/2007 - Go to receive mode in the ISR as well - the ISR to
            // task latency sometimes is in the order of 100 ms. This causes the
            // transceiver to miss data - do nothing in this state

            break;

        case SEND_APP_ACK:
            // MNT - 10/18/2007 -  The app ack is now sent in the MCPSDataIndication function itself
            // This happens in the ISR and will speed things up.
            break;

        case TIMEOUT_STATE:
            if (u8RetryNo < SMAC_RETRY_COUNT) {
                SMAC_SET_APP_STATE(RE_TRANSMIT_DATA); /* Retransmit. */
#if  VERBOSE_PRINTF
                DmConsolePrintf("RE%d:0x%x\r\n", u8RetryNo, Rfdiags_LowLevelTxPacketCnt);
#endif
                Rfdiags_LowLevelRetryPacketCnt++;
                u8RetryNo++;
                // MNT - 4/24/2007 - Done transmitting. Set the flags to receive data
                SMAC_LOG_DEBUG_STATE(gi8AppStatus, SMAC_SM_DEBUG_EVENT_TIMEOUTSTATE_RETR);
#if defined (OS_NUCLEUS)
                NU_Set_Events(&TxRxTask.events, RF_TRX_TX_RETX, NU_OR);
#elif defined (OS_WINCE)
                SetEvent(TxRxTask.hEvents[RF_TRX_TX_RETX]);
#endif
                OsSetEvent(TxRxTask.events, RF_TRX_TX_RETX);
            }
            else {
                /* Give up on packet. Send the NACK*/
                smac_dataConfMsg.msgType = gMcpsDataCnf_c;
                smac_dataConfMsg.msgData.dataCnf.msduHandle = TxFrameToSMAC.msduHandle;
                smac_dataConfMsg.msgData.dataCnf.status = gNoAck_c;
#if defined (OS_NUCLEUS)
                MSG_Queue(&Rf_Smac_Shim.McpsNwkInputQueue, &smac_dataConfMsg, sizeof(smac_dataConfMsg));
#elif defined (OS_WINCE)
                MSG_Queue(Rf_Smac_Shim.hWriteMcpsNwkInputQueue, &smac_dataConfMsg, sizeof(smac_dataConfMsg));
#endif
                HPRF_QUEUE_DEBUG(DmConsolePrintf("=== %s:%i ---> queueing %u bytes to mcpsNwkInputQueue\n", \
                        __FUNCTION__, __LINE__, \
                        sizeof(smac_dataConfMsg));)
                OsQueueBytes(Rf_Smac_Shim.hMcpsNwkInputQueue, &smac_dataConfMsg, sizeof(smac_dataConfMsg));

                SMAC_SET_APP_STATE(RECEIVER_ALWAYS_ON);
                u8RetryNo = 0;
                // MNT - 5/4/2007 - Increment the sequence number because the packet
                // was not acknowledged and we gave up
                smac_currSeqNo++;
                // MNT - 4/24/2007 - Done transmitting. Set the flags to receive data
                SMAC_LOG_DEBUG_STATE(gi8AppStatus, SMAC_SM_DEBUG_EVENT_TIMEOUTSTATE_GIVEUP);
#if defined (OS_NUCLEUS)
                NU_Set_Events(&TxRxTask.events, RF_TRX_RX_PACKET, NU_OR);
#elif defined (OS_WINCE)
                SetEvent(TxRxTask.hEvents[RF_TRX_RX_PACKET]);
#endif
                OsSetEvent(TxRxTask.events, RF_TRX_RX_PACKET);
                Rfdiags_LowLevelTotalLostPackets++;
            } // retry count
            break;

        default:
            break;

        } // switch (gi8AppStatus)

        //RFIntHostApp.pF_HwDelayUsec(10);
        //ResetSoftwareWatchdogTimer();

    } // for(;;)
}








/**
 *
 * \date        04-18-2007
 *
 * \author      mtalreja
 *
 * \brief       MC13192PHY_HISR
 *
 * \detail      MC13192 HISR
 *
 * \return      Nothing
 *
 * \retval      
 *
 * \param vector_num 
 */
#if defined (OS_NUCLEUS)	// This (and HISR are replaced by HPR_IntrThread() in this file.
void MC13192_LISR(int vector_num)	
{
  CLEAR_IRQ_FLAG(); /* Acknowledge the interrupt. MC13192 IRQ pin still low. */     
 
  NU_Activate_HISR(&RFPhyISR.RfPhyHISR);
}
#endif

/**
 *
 * \date        05-04-2007
 *
 * \author      mtalreja
 *
 * \brief       AreBytesDiff
 *
 * \detail      Compares byte arrays and returns as soon as it detects a failure.
 *              Inline if necessary.
 *
 * \return      T/F
 *
 * \retval      
 *
 * \param *lhs 
 * \param *rhs 
 * \param numbytes 
 * \return 
 */
BOOL AreBytesDiff(UINT8 *lhs, UINT8 *rhs, UINT16 numbytes)
{
  UINT16 ctr;

  if ((lhs == 0) || (rhs == 0))
  {
    return TRUE;
  } //if ((lhs == 0) || (rhs == 0))

  for (ctr=0; ctr<numbytes; ctr++)
  {
    if (*(lhs+ctr) != *(rhs+ctr))
    {
      return TRUE;
    } // if (lhs[ctr] != rhs[ctr])
  } // for (ctr=0; ctr<numbytes; ctr++)

  return FALSE;

}













// MNT - 5/7/2007 - Added the following functions to mimic the Freescale stack


/**
 *
 * \date        05-07-2007
 *
 * \author      mtalreja
 *
 * \brief       MacPhyInit_WriteExtAddress
 *
 * \detail      Set the Extended address
 *
 * \return      Nothing
 *
 * \retval      
 *
 * \param *pExtendedAddress 
 */
void MacPhyInit_WriteExtAddress(uint8_t *pExtendedAddress)
{
  memcpy(&Rf_Smac_802_PHYParams.deviceExtendedAddress, pExtendedAddress, sizeof(Rf_Smac_802_PHYParams.deviceExtendedAddress));
}


/**
 *
 * \date        05-07-2007
 *
 * \author      mtalreja
 *
 * \brief       MacPhyInit_ReadExtAddress
 *
 * \detail      Returns the extended address stored in the database. Once the
 *              user gets this pointer, the Extended address could be easily
 *              corrupted. So, care must be taken to not affect it.
 *
 * \return      
 *
 * \retval      
 *
 * \param void 
 * \return 
 */
uint8_t *MacPhyInit_ReadExtAddress(void)
{
  return (uint8_t*)&Rf_Smac_802_PHYParams.deviceExtendedAddress;
}




/**
 *
 * \date        06-14-2007
 *
 * \author      mtalreja
 *
 * \brief       SMAC_SM_TurnOnRxWTO
 *
 * \detail      Turn on receiver with time out. This will now be called by the ISR
 *              for quick turnaround to receive mode when an ACK is received.
 *
 * \return      Nothing
 *
 * \retval      
 *
 * \param void 
 */
void SMAC_SM_TurnOnRxWTO(UINT32 timeout)
{
  SMAC_LOG_DEBUG_STATE (gi8AppStatus, SMAC_SM_DEBUG_EVENT_STARTRX_WTO);
  SMAC_SET_APP_STATE(WAITING_FOR_ACK); 
  (void)MLMERXEnableRequest(&Smac_gsRxPacket, timeout);
  SMAC_LOG_DEBUG_STATE (gi8AppStatus, SMAC_SM_DEBUG_EVENT_RX_WTO_STARTED);
}




/**
 *
 * \date        06-22-2007
 *
 * \author      mtalreja
 *
 * \brief       SMAC_SM_ResetPhy_And_Nack
 *
 * \detail      Detailed description
 *
 * \return      What is returned
 *
 * \retval      
 *
 * \param void 
 */
void SMAC_SM_ResetPhy_And_Nack(void)
{
	 mcpsToNwkMessage_t smac_dataConfMsg;
	 g_bRxPktSinceReset = FALSE;
     Smac_ResetDoneFlag = FALSE;

	// MNT - 6/22/2007 - First check the mode to see if we have a packet in progress
	// from the upper layers and send the nack

	if ( (gi8AppStatus == TRANSMIT_DATA) || (gi8AppStatus == RE_TRANSMIT_DATA)  
    || (gi8AppStatus == RECEIVER_ON_WTO) || (gi8AppStatus == TXACK_WTO) 
    || (gi8AppStatus == TIMEOUT_STATE) || (gi8AppStatus == WAITING_FOR_ACK) ) 
	{
		smac_dataConfMsg.msgType = gMcpsDataCnf_c;
		smac_dataConfMsg.msgData.dataCnf.msduHandle = TxFrameToSMAC.msduHandle;
		smac_dataConfMsg.msgData.dataCnf.status     = gNoAck_c;
#if defined (OS_NUCLEUS)
		MSG_Queue(&Rf_Smac_Shim.McpsNwkInputQueue, &smac_dataConfMsg, sizeof(smac_dataConfMsg));
#elif defined (OS_WINCE)
		MSG_Queue(Rf_Smac_Shim.hWriteMcpsNwkInputQueue, &smac_dataConfMsg, sizeof(smac_dataConfMsg));
#endif
		HPRF_QUEUE_DEBUG(DmConsolePrintf("=== %s:%i ---> queueing %u bytes to mcpsNwkInputQueue\n", \
                __FUNCTION__, __LINE__, \
                sizeof(smac_dataConfMsg));)
		OsQueueBytes(Rf_Smac_Shim.hMcpsNwkInputQueue, &smac_dataConfMsg, sizeof(smac_dataConfMsg));
		u8RetryNo = 0;
		// MNT - 5/4/2007 - Increment the sequence number because the packet
		// was not acknowledged and we gave up
		smac_currSeqNo++;
	} // if ( (gi8AppStatus == TRANSMIT_DATA) || (gi8AppStatus == RE_TRANSMIT_DATA)  
		// || (gi8AppStatus == RECEIVER_ON_WTO) || (gi8AppStatus == TXACK_WTO) 
		// || (gi8AppStatus == TIMEOUT_STATE) || (gi8AppStatus == WAITING_FOR_ACK)  )

	  // MNT - 7/20/2007 - Flag the completion of the transmission when 
	  // this function is called. Tell the transmit task that an error occured.
	  // This will allow it to send a failure and allow the retry mechanism
	  // to kick in.
	  if (gTxInProgress == 1)
	  {
		gTxInProgress = 0;
		gTxLOUnlocked = 1;
#if defined (OS_NUCLEUS)
		NU_Set_Events(&TxRxTask.txEvent, RF_TX_TXDONE, NU_OR);
#elif defined (OS_WINCE)
		SetEvent(TxRxTask.hTxEvent);
#endif
		OsSignalEvent(TxRxTask.hTxEvent);
	} // if (gTxInProgress == 1)

	  Rfdiags_NumResetAndNacks++;

	  // MNT - 6/22/2007 - Force the PHY to idle state till we get a reset back
	  gi8AppStatus = IDLE_STATE;	//MC13192 idle, re-initialize.
#if defined (OS_NUCLEUS)
  NU_Set_Events(&TxRxTask.events, RF_TRX_RX_ON, NU_OR);
#elif defined (OS_WINCE)
  SetEvent(TxRxTask.hEvents[RF_TRX_RX_ON]);
#endif
  	  OsSetEvent(TxRxTask.events, RF_TRX_RX_ON);

  // MNT - 6/22/2007 - Send the soft reset after setting the correct state because
  // the the ISR could come after the states have moved
  // MNT - 11/5/2007 - For some reason, the PHY keeps interrupting even though the
  // reset register has been written to. This causes weird lockup issues. We will
  // first force the chip to go to idle state before resetting.
  PLMESetTrxStateRequest(IDLE_MODE);
  PLMEMC13192SoftReset();

}





// MNT - 7/11/07 - Moved the SMAC_MCU_Init to smac_app.c. This function did not have
// any processor specific code. Moving to smac_app.c allows control of this file without
// affecting the hardware specific stuff. 

/*!
  \fn void SMAC_MCUInit() 
  \brief	Initialize the MCU COP, GPIO, SPI and IRQ.
   Set the desired MC13192 clock frequency here.
  \sa GPIOInit()
  \sa SPIInit()
  \sa IRQInit()
  \sa IRQACK()             
  \sa SPIDrvRead()
  \sa IRQPinEnable() 
*/

//TODO: Verify this number. Copying WINCE since the hardware is the same.
#if defined (OS_NUCLEUS)
    static const INT32 startup_timeout = (1024);
#elif defined (OS_WINCE)
    // Faster processor
    static const INT32 startup_timeout = (1024*4);
#elif defined (OS_LINUX)
    static const INT32 startup_timeout = (1024*4);
#endif


void SMAC_MCUInit(void)
{
    ///////////////////////////////////////////////
    // NOTE: Any changes to this function may also
    // need change in the SMAC_MCUPowerUp()    
    ///////////////////////////////////////////////
    
    UINT16 u16IrqReg =0;
    UINT8 u8AttnIrq = FALSE;
	INT32 timeout = startup_timeout;

	// MNT - 4/5/2007 - Should we physically reset here?
    /// \review
    MC1319xDrv_Assert_Reset();          /* Take MC13192 out of reset */
    gu8RTxMode = RESET_DELAY;
    
    // MNT - 4/5/2007 - Add a 1ms delay here -see if this is going to cause problems
    // Should not be called in the ISR
    HwDelayMsec(1);
    //RFIntHostApp.pF_HwDelayMsec(1);

    gu8RTxMode = SYSTEM_RESET_MODE;
    SMAC_GPIOInit();
    SMAC_SPIInit();
    gu8RTxMode = MC13192_RESET_MODE;
    MC1319xDrv_Deassert_Reset();          /* Take MC13192 out of reset */

    SPIDrvWrite(0x00, 0x0000);/*soft reset*/

    while ((u8AttnIrq == FALSE) && (timeout--))
    {
        if (IRQFLAG()) 
        {      /* Check to see if IRQ is asserted */
            u16IrqReg = SPIDrvRead(0x24);   /* 
                                             * Clear MC13192 interrupts and  
                                             * check for ATTN IRQ from 13192
                                             */
			u16IrqReg &= 0x400;
            if (u16IrqReg == 0) 
            {
                u8AttnIrq = FALSE;
            } //if (u16IrqReg == 0) 
            else 
            {
                u8AttnIrq = TRUE;
            } // endif (u16IrqReg == 0) 
        } //if (IRQFLAG()) 

        MCU_LOW_POWER_WHILE();
    } //while (u8AttnIrq == FALSE)

    // MNT - 7/11/07 - At this point if we time out, we should just return after logging an error
    // and marking the PHY invalid
    if (timeout <= 0)
    {
	    Smac_PhyInitialized = FALSE;
	    DmConsoleLevelPrintf(DM_ERROR_LEVEL_ERROR, "StackInit - PHY did not respond to a reset request. STACK NOT INITIALIZED\n");
        Rfdiags_LowLevelPhyInitFailures++;
    } //if (timeout <= 0)
    else
    {
        Smac_PhyInitialized = TRUE;
    } //if (timeout <= 0)

 
    if (Smac_PhyInitialized)
    {
        (void)PLMEPhyReset();       /* Reset the phy to its default settings */
        IRQACK();					/* ACK the pending IRQ interrupt */
        IRQPinEnable();		/* Pin Enable, IE, IRQ CLR, negative edge. */
        SMAC_IRQInit();      /* Turn on the IRQ pin. */
    }
    gu8RTxMode = MC13192_CONFIG_MODE;
}

/**
 * \author         original
 * \brief          This function initializes PHY chip, when powering up
 * \detail         This function is used to initialize the PHY chip when coming
 *                 out of suspend mode (or sleep mode), where we power up the hardware
 *                 but all the stack is already up and running. This is based on the 
 *                 SMAC_MCUInit()
 * \date           05/18/2010 4:30:PM
 *  \param         None
 *  \return        
 */
void SMAC_MCUPowerUp(void)
{
    UINT16 u16IrqReg =0;
    UINT8 u8AttnIrq = FALSE;
    INT32 timeout = startup_timeout;

    // Reset chip here
    MC1319xDrv_Assert_Reset();          /* Take MC13192 out of reset */
    
    HwDelayUsec(100);
    MC1319xDrv_Deassert_Reset();        /* Take MC13192 out of reset */

    SPIDrvWriteNoIrq(0x00, 0x0000);          /* soft reset*/

    while ((u8AttnIrq == FALSE) && (timeout--))
    {
        if (IRQFLAG()) 
        {   
            /* Check to see if IRQ is asserted */
            u16IrqReg = SPIDrvReadNoIrq(0x24);   /*
                                             * Clear MC13192 interrupts and  
                                             * check for ATTN IRQ from 13192
                                             */
			u16IrqReg &= 0x400;
            if (u16IrqReg == 0) 
            {
                u8AttnIrq = FALSE;
            }
            else 
            {
                u8AttnIrq = TRUE;
            }
        }
        MCU_LOW_POWER_WHILE();
    }
    // MNT - 7/11/07 - At this point if we time out, we should just return after logging an error
    // and marking the PHY invalid
    if (timeout <= 0)
    {
        DmConsoleLevelPrintf(DM_ERROR_LEVEL_ERROR, "\r\nERROR: SMAC Power Up - PHY did not respond to a reset request.\r\n");
    }

	// Windows CE does not like System API calls inside power handlers
#if !defined (OS_WINCE)
    IRQACK();		    /* ACK the pending IRQ interrupt */
#endif
    MC13192Init();     /* Pass argument 0 to indicate it is not initialization sequence */
    SPIDrvWrite(GPIO_CONFIG, 0x03F8);

    // MNT - 1/21/2008 - Now write to the GPIO register and make sure that the values on the
    // pins match what they are supposed to be. By default, all GPIOs on the PHY are configured
    // as output. Leave the config bits the same as in MC13192Init
#if MC13192_IRQ_PULLUP_ENABLE
	SPIDrvWrite(GPIO_DATA, (IRQ_PULL_UP_MASK | SMAC_FCC_SIGNATURE | SMAC_GPIO_CONFIG_BITS));
#else
	SPIDrvWrite(GPIO_DATA, (SMAC_FCC_SIGNATURE | SMAC_GPIO_CONFIG_BITS));
#endif

// Windows CE does not like System API calls inside power handlers
#if !defined (OS_WINCE)
    // Enable the interrupts (we disabled it in PowerDown)
    MC13192RestoreInterrupts();
#endif
}

/**
 * \author         original
 * \brief          This function does necessary things for the SMAC before shutting down
 * \detail         Used when going in to suspend (or sleep) mode, where we switch off the
 *                 radio power. Do necessary things for the SMAC before that.
 * \date           05/18/2010 4:30:PM
 *  \param         None
 *  \return        
 */
void SMAC_MCUPowerDown(void)
{
    // For now, only ack any pending IRQs, just to be safe. If need arises in the future
    // we may want to stick in some stuff from SMAC_SM_ResetPhy_And_Nack() here.
    // Windows CE does not like System API calls inside power handlers
	// Hence no need for thia code. 
	// Also, the RF power chip is powered down in power down
#if !defined (OS_WINCE)
    IRQACK();		    /* ACK the pending IRQ interrupt */
   
	/* disable interrupts to avoid double access to zigbee spi */
    MC13192DisableInterrupts();
    // Windows CE does not like System API calls inside power handlers

    IRQACK();		    /* ACK the pending IRQ interrupt */
#endif
}


#if defined (OS_WINCE)
/**
 * \author         original
 * \brief          This function acts as the IST for the MC13192
 * \detail         As interrupts are triggered, windows messages are sent to notify
 *                 applications
 * \date           04/30/03 2:55:PM
 *  \param         context - pointer to hprf_t structure
 *  \return        dword indicating success or failure
 *  \retval        non zero value indicates success
 */
DWORD HPR_IntrThread(VOID *pContext)
{
    hprf_hw_dev *pDevice = (hprf_hw_dev*)pContext;
    DWORD dwResult = 0;	

    if (pDevice == NULL)
    {
        DmConsoleLevelPrintf(DM_ERROR_LEVEL_ERROR, "HPR_IntrThread: NULL context!");
        goto cleanup;
    }

    DmConsoleLevelPrintf(DM_ERROR_LEVEL_ERROR, "\r\nHPR_IntrThread: Running!\r\n");

    // get ridd of any pending Interrupt (this also clears the interrupt mask)
    InterruptDone(pDevice->dwHprfSysintr);

    // Loop until we are stopped...
    while (!pDevice->intrThreadExit)
    {
        dwResult = WaitForSingleObject(pDevice->hHprfIntrEvent, INFINITE);

        if (pDevice->intrThreadExit)
        {
            goto cleanup;
        }
        // Call the process function, only if wait success
        if (dwResult == WAIT_OBJECT_0)
        {
            MC13192_HISR();            
		}
        else
        {
            // else its an error, so log the error
            DmConsoleLevelPrintf(DM_ERROR_LEVEL_ERROR, "ERROR (HPR_IntrThread): wait on Intr Evnt");
        }

        // Interrupt is done
        InterruptDone(pDevice->dwHprfSysintr);
    }

cleanup:
    
    return ERROR_SUCCESS;
}
#endif
